/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "ExecutableCommand.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file ExecutableCommand.cxx */

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------

	/*
	* Creates a command with the given text
	* @param aText Is the text to assign to the command
	* @return Returns the created ExecutableCommand pointer
	*/
	ExecutableCommand :: ExecutableCommand(std::string aText)
	{ 
		setText(aText);	
		std::cout<<"execComm created "<< aText.data()<<std::endl;//SIL
	}

	/*
	* Destroys the command
	*/
	ExecutableCommand :: ~ExecutableCommand()
	{ 
		clear();
	}

	

//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* Gets the text of the command
	* @return text Is the text of the command
	*/
	std::string ExecutableCommand :: getText()
	{
		return text;
	}

	/*
	* Sets the text of the command
	* @param theText Is the text of the command
	*/
	void ExecutableCommand :: setText(std::string theText)
	{ 
		text = theText;
	}
	
	/*
	* Includes the command into the given queue for execution
	* @param executionQueue Is the queue in which is included the command
	*/
	void ExecutableCommand :: includeToExecute(std::deque<CommandObject *> & executionQueue)
	{
		executionQueue.push_back( this );
	}


	/*
	* Virtual method implementation that returns 1 as the ExecutableCommand is just one command effective
	* @return The value of commands that represents this
	*/
	int ExecutableCommand :: count()
	{
		return 1;
	}

	/*
	* Method that clears the command
	*/
	void ExecutableCommand :: clear()
	{
		
	}
