/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __EXECUTABLE_COMMAND__
#define __EXECUTABLE_COMMAND__



//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <iostream>
#include "CommandObject.h"

class ExecutableCommand : public CommandObject{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:

	/*
	* Creates a command (executable) with the given text
	* @param aText Is the text to assign to the command
	* @return Returns the created ExecutableCommand pointer
	*/
	ExecutableCommand(std::string aText );

	/*
	* Destroys the command
	*/
	virtual ~ExecutableCommand( );
//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------


	/*
	* Gets the text of the command
	* @return text Is the text of the command
	*/
	std::string getText();

	/*
	* Sets the text of the command
	* @param theText Is the text of the command
	*/
	void setText(std::string theText);

	/*
	* Includes the command into the given queue for execution
	* @param executionQueue Is the queue in which is included the command
	*/
	virtual void includeToExecute(std::deque<CommandObject * > & executionQueue);

	/*
	* Counts the command(s)
	* @return The value of commands that represents this
	*/
	virtual int count();

	/*
	* Method that clears the command
	*/
	virtual void clear();

//------------------------------------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------------------------------------

private: 	
//------------------------------------------------------------------------------------------------------------
// Attributes
//------------------------------------------------------------------------------------------------------------

	/*
	* Represents the text of the command
	*/
	std::string text;
	
};
#endif
