/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __ICOMMANDS_USER__
#define __ICOMMANDS_USER__


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------

#include <iostream>
#include <deque>
#include "CommandObject.h"

class ICommandsUser{

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:
   virtual ~ICommandsUser() {};

	
//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	
	/*
	* Executes a command by resending the received parameters to its parent to do the appropiate interpretation and execution.
	* @param theCommand Is the command to execute
	* @param fromRegistration Indicates if the execution is directed from the registration, by default comes from the GUI = false.
	*/
	virtual bool executeCommand(CommandObject * theCommand, bool fromRegistration=false) = 0;
	
	/*
	* Executes a command queue by resending the received parameters to its parent to do the appropiate interpretation and execution.
	* @param executionQueue Is the command queue to execute
	* @param fromRegistration Indicates if the execution is directed from the registration, by default comes from the GUI = false.
	*/
	virtual bool executeCommandsQueue(std::deque<CommandObject *> & executionQueue, bool fromRegistration) = 0;

	
};
#endif

