/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "ImageSectionThing.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file ImageSectionThing.cxx */

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------

	/*
	* Creates the section image with the given image
	* @param sourceImage The image data to set.
	*/
	ImageSectionThing :: ImageSectionThing(vtkImageData * theImage)
	{
		setImageData(theImage);
	}

	/*
	* Destroys the image section
	*/
	ImageSectionThing :: ~ImageSectionThing()
	{

	}
//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* Gets the image data 
	* @return image The image.
	*/
	vtkImageData * ImageSectionThing :: getImageData()
	{
		return image;
	}

	/*
	* Sets the source image 
	* @param theImage The image to set.
	*/
	void ImageSectionThing :: setImageData( vtkImageData *  theImage)
	{
		image = theImage;
	}
   
   
