/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "ImageSourceThing.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file ImageSourceThing.cxx */

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------

	/*
	* Creates the source image with the given parameter
	* @param sourceImage The image source to set.
	*/
	ImageSourceThing :: ImageSourceThing(vtkImageData * theSource)
	{
		setSourceImage(theSource);
	}

	/*
	* Destroys the image source
	*/
	ImageSourceThing :: ~ImageSourceThing()
	{

	}
//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* Gets the source image 
	* @return sourceImage The image source.
	*/
	vtkImageData * ImageSourceThing :: getSourceImage()
	{
		return sourceImage;
	}

	/*
	* Sets the source image 
	* @param sourceImage The image source.
	*/
	void ImageSourceThing :: setSourceImage( vtkImageData *  theSource)
	{
		sourceImage = theSource;
	}
   
   /**
	* Gets the max value of the x-axis
	* @return x-extend_MAX
	*/
	int ImageSourceThing :: getMax_X()
	{ 
		int x1, x2, y1, y2, z1, z2;
		sourceImage ->GetExtent( x1, x2, y1, y2, z1, z2);
		return x2;
	}

	/**
	* Gets the min value of the x-axis
	* @return x-extend_MIN
	*/
	int ImageSourceThing :: getMin_X()
	{ 
		int x1, x2, y1, y2, z1, z2;
		sourceImage ->GetExtent( x1, x2, y1, y2, z1, z2);
		return x1;
	}

	/**
	* Gets the range values of the x-axis
	* @return x-extend pointer to a 2 sized []
	*/
	int * ImageSourceThing :: getRangeX()
	{
		int x1, x2, y1, y2, z1, z2;
		sourceImage ->GetExtent( x1, x2, y1, y2, z1, z2);
		int* retVal = new int[2];
		retVal[0]= x1;
		retVal[1]= x2;
		return retVal;
	}

	/**
	* Gets the max value of the y-axis
	* @return y-extend_MAX
	*/
	int ImageSourceThing :: getMax_Y()
	{
		int x1, x2, y1, y2, z1, z2;
		sourceImage ->GetExtent( x1, x2, y1, y2, z1, z2);
		return y2;
	}

	/**
	* Gets the min value of the y-axis
	* @return y-extend_MIN
	*/
	int ImageSourceThing :: getMin_Y()
	{
		int x1, x2, y1, y2, z1, z2;
		sourceImage ->GetExtent( x1, x2, y1, y2, z1, z2);
		return y1;
	}

	
	/**
	* Gets the range values of the y-axis
	* @return y-extend pointer to a 2 sized []
	*/
	int * ImageSourceThing :: getRangeY()
	{ 
		int x1, x2, y1, y2, z1, z2;
		sourceImage ->GetExtent( x1, x2, y1, y2, z1, z2);
		int* retVal = new int[2];
		retVal[0]= y1;
		retVal[1]= y2;
		return retVal;

	}

	/**
	* Gets the max value of the z-axis
	* @return z-extend_MAX
	*/
	int ImageSourceThing :: getMax_Z()
	{
		int x1, x2, y1, y2, z1, z2;
		sourceImage ->GetExtent( x1, x2, y1, y2, z1, z2);
		return z2;
	}

	/**
	* Gets the min value of the z-axis
	* @return z-extend_MIN
	*/
	int ImageSourceThing :: getMin_Z()
	{ 
		int x1, x2, y1, y2, z1, z2;
		sourceImage ->GetExtent( x1, x2, y1, y2, z1, z2);
		return z1;
	}

	
	/**
	* Gets the range values of the z-axis
	* @return z-extend pointer to a 2 sized []
	*/
	int * ImageSourceThing :: getRangeZ()
	{ 
		int x1, x2, y1, y2, z1, z2;
		sourceImage ->GetExtent( x1, x2, y1, y2, z1, z2);
		int* retVal = new int[2];
		retVal[0]= z1;
		retVal[1]= z2;
		return retVal;


	}

	
	/**
	* Gets the range values of the x-axis
	* @return x-extend pointer to a 6 sized []
	*/
	int * ImageSourceThing :: getAllRanges()
	{ 
		return sourceImage-> GetExtent();
	}
