/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "InstantMembersNameList.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file InstantMemberNameList.cxx */

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------

	/*
	* Create the InstantMembersNameList with empty data pointers
	*/
	InstantMembersNameList :: InstantMembersNameList()
	{
		actualAxeNamesWrapp				= new NameWrapper("","");
		actualSourceImageNamesWrapp		= new NameWrapper("","");
		actualSectionImageNamesWrapp	= new NameWrapper("","");
		actualOutlineNamesWrapp			= new NameWrapper("","");
	}

	/*
	* Destroys the InstantMembersNameList
	*/
	InstantMembersNameList :: ~InstantMembersNameList()
	{
		clean();
		outlinesNamesVector.clear();
		axesNamesVector.clear();
	}

//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------
	/*
	* Sets the actual outline names pair
	* @param thekeyName The key name asigned to the actual outline	
	* @param theRealName The real name asigned to the actual outline
	*/
	void InstantMembersNameList :: setActualOutline(std::string thekeyName, std::string theRealName )
	{
		actualOutlineNamesWrapp->setWrappingPair(thekeyName, theRealName);
	}

	/*
	* Sets the actual axes names pair
	* @param thekeyName The key name asigned to the actual outline	
	* @param theRealName The real name asigned to the actual outline
	*/
	void InstantMembersNameList :: addOutlineName(std::string thekeyName, std::string theRealName)
	{
		NameWrapper * outlineWrap = new NameWrapper (thekeyName, theRealName);
		outlinesNamesVector.push_back(outlineWrap);
	}	
	
	/*
	* Sets the actual axes names pair
	* @param thekeyName The key name asigned to the actual axe	
	* @param theRealName The real name asigned to the actual axe
	*/
	void InstantMembersNameList :: setActualAxeWrap(std::string thekeyName, std::string theRealName)
	{
		actualAxeNamesWrapp -> setWrappingPair(thekeyName, theRealName);
	}

	/*
	* Gets the actual axes key name
	* @return actualAxeKeyName The key name asigned to the actual axe
	*/
	std::string InstantMembersNameList :: getActualAxeKeyName()
	{
		return actualAxeNamesWrapp->getKeyName();
	}

	/*
	* Gets the actual axes key name
	* @return actualSourceImageKeyName The key name asigned to the actual axe
	*/
	std::string InstantMembersNameList :: getActualSourceImageKeyName()
	{
		return actualSourceImageNamesWrapp->getKeyName();
	}

	/*
	* Gets the actual axes key name
	* @return actualSectionImageKeyName The key name asigned to the actual axe
	*/
	std::string InstantMembersNameList :: getActualSectionImageKeyName()
	{
		return actualSourceImageNamesWrapp->getKeyName();
	}

	/*
	* Gets the vector of the key names of currect instant outlines
	* @return vectorPairedNames The vector with the pair of outline names wrapping
	*/
	std::vector<NameWrapper *> InstantMembersNameList :: getOutlinesNamesVector()
	{
		return outlinesNamesVector;
	}

	/*
	* Sets the actualSourceImage names pair
	* @param thekeyName The key name asigned to the actual outline	
	* @param theRealName The real name asigned to the actual outline
	*/
	void InstantMembersNameList :: setActualSourceImageNamesWrapp(std::string thekeyName, std::string theRealName)
	{
		actualSourceImageNamesWrapp = new NameWrapper(thekeyName,theRealName);
	}

	/*
	* Sets the actualSectionImage names pair
	* @param thekeyName The key name asigned to the actual outline	
	* @param theRealName The real name asigned to the actual outline
	*/
	void InstantMembersNameList :: setActualSectionImageNamesWrapp(std::string thekeyName, std::string theRealName)
	{
		actualSectionImageNamesWrapp = new NameWrapper(thekeyName,theRealName);
	}

	/*
	* Cleans the vector and the information of the instant members wrapping
	*/
	void InstantMembersNameList :: clean()
	{
		
		/*
		if(!outlinesNamesVector.empty())
		{while(outlinesNamesVector.size()>0)
			outlinesNamesVector.pop_back();
		}
		if ( !axesNamesVector.empty())
		{
		while(axesNamesVector.size()>0)
			axesNamesVector.pop_back();
		}
		*/
		outlinesNamesVector.clear();
		axesNamesVector.clear();
		/*
		delete actualAxeNamesWrapp;
		delete actualSourceImageNamesWrapp;
		delete actualSectionImageNamesWrapp;
		delete actualOutlineNamesWrapp;*/
	}
   
   
