/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "KernelManagerContour.h"


KernelManagerContour::KernelManagerContour(){


/**THIS ALL SHOULD BE IN AN OTHER LIB CALLED PERSISTANCE
**
**/
	inredo = 0;
	inundo = 0;

	time_t seconds;
	seconds = time (NULL);
	int time = seconds;


	stundoredo = "data/temp"+intToString(time);
	_currentIndex = 0;

	_contourPropagation = NULL;
#if(WIN32)
		mkdir(stundoredo.c_str());
#else
		mkdir(stundoredo.c_str(),755);
#endif
	stundoredo += "/cont";
/**
**  FINISH PERSISTANCE
**/

}
KernelManagerContour::KernelManagerContour(std::vector<vtkImageData*> images,std::string datadir,std::string tmpdir)
{


/**THIS ALL SHOULD BE IN AN OTHER LIB CALLED PERSISTANCE
**
**/
	inredo = 0;
	inundo = 0;

	time_t seconds;
	seconds = time (NULL);
	int time = seconds;


	stundoredo = tmpdir+"/temp"+intToString(time);
	_currentIndex = 0;

	_contourPropagation = NULL;
#if(WIN32)
   	mkdir(tmpdir.c_str());
	mkdir(stundoredo.c_str());
#else
	mkdir(tmpdir.c_str(),755);
	mkdir(stundoredo.c_str(),755);
#endif
	stundoredo += "/cont";
/**
**  FINISH PERSISTANCE
**/
	setVectImages(images);        
	initializeEnvironment(datadir);

}

KernelManagerContour::~KernelManagerContour()
{
}

std::vector<vtkImageData*> KernelManagerContour::getVectImages()
{
	return vectimages;
}


void KernelManagerContour::setVectImages(std::vector<vtkImageData*> vectimg)
{
	double spc[3];
	std::vector<double> vectspc;
	
	for(int i = 0; i < (int)(vectimg.size()); i++){
		vtkImageData* img = vectimg[i];
		vtkImageChangeInformation* change = vtkImageChangeInformation::New();
		change->SetInformationInput(img);
		change->SetInputConnection(img->GetProducerPort());
		img->GetSpacing(spc);
		change->SetOutputSpacing(1,1,1);

//EED 18 fev 2014
		change->SetOutputOrigin (0, 0, 0);

		change->Update();
		vectspc.clear();

		vectspc.push_back(spc[0]);
		vectspc.push_back(spc[1]);
		vectspc.push_back(spc[2]);
		vectimagesSpacing.push_back(vectspc);
		vectimg[i] = change->GetOutput();
	}

	vectimages = vectimg;
}


void KernelManagerContour::GetSpacing(double *vecspc, int iImage)
{
	vecspc[0]=vectimagesSpacing[iImage][0];
	vecspc[1]=vectimagesSpacing[iImage][1];
	vecspc[2]=vectimagesSpacing[iImage][2];
}


void KernelManagerContour::initializeEnvironment(std::string datadir){
	_datadir = datadir;
	std::string conceptsFN			=  datadir+"holaConceptsFile.cf";
	std::string imageSourcesFN		=  datadir+"holaImagesInstantsFile.of";
	std::string imageSectionsFN		= "";
	std::string axeThingsFN			= "";

	std::map<std::string, ImageSourceThing *> * sourcesMap		= new std::map<std::string, ImageSourceThing *>();
	std::map<std::string, ImageSectionThing *>* sectionsMap		= new std::map<std::string, ImageSectionThing *>();
	std::map<std::string, AxeThing *>* axesMap					= new std::map<std::string, AxeThing *>();
	std::map<std::string, ContourThing *>* outlinesMap			= new std::map<std::string, ContourThing *>();

	for(int i = 0; i < (int)(vectimages.size()); i++){
		vtkImageData* selectedimage = vectimages[i];
		ImageSourceThing * thing									= new ImageSourceThing(selectedimage);
		std::string imgstring = "Source Image "+intToString(i+1);
		sourcesMap->insert(std::pair<std::string, ImageSourceThing *>( imgstring, thing));
	}


	OutlineModelBuilder * _builder								= new OutlineModelBuilder( conceptsFN ,datadir);
	_builder->buildImageSource_Envornment( imageSourcesFN, sourcesMap );
	_builder->buildImageSection_Envornment( imageSectionsFN, sectionsMap );
	_builder->buildAxe_Envornment(axeThingsFN, axesMap );
	_builder->buildCountour_Envornment( imageSectionsFN, outlinesMap );

	//Creating the objects to manage
	modelManager				= new OutlineModelManager( _builder->getImSourceEnv(), _builder->getImSectionEnv(), _builder->getAxesEnv(),  _builder->getContourEnv() );

	imageSource	= modelManager->getImageSourceThingByKeyName( "Source Image 1" );

}
vtkImageData* KernelManagerContour::getSourceImage(){
	return imageSource->getSourceImage();
}
OutlineModelManager* KernelManagerContour::getOutlineModelManager(){
	return modelManager;
}

std::string KernelManagerContour::createOutline(manualBaseModel * manModelContour,std::vector<int> instantVector){
	return modelManager->createOutline( manModelContour, instantVector );
}

std::string KernelManagerContour::intToString(int num){
	std::string result;
	if(num == 0){
		result = "0";
	}else{
		int k=num;
		while (k > 0){
			char temp = k % 10 + 48;
			k = k / 10;
			result = temp + result;
		}
	}
	return result;
}

std::vector<std::string> KernelManagerContour::GetLstNameThingsStatic(){
	return modelManager->GetLstNameThingsStatic();
}

void KernelManagerContour::SaveThingName(FILE* pFile, FILE *pFileData, std::string name ){
	modelManager->SaveThingName(pFile, pFileData, name);
}
std::vector<std::string> KernelManagerContour::GetLstNameThings(){
	return modelManager->GetLstNameThings();
}
//int KernelManagerContour::IsPartOfStaticList(std::string keyName ){
//	return modelManager->IsPartOfStaticList(keyName);
//}

bool KernelManagerContour::IsPartOfStaticList(std::string theKeyName){
	return modelManager->IsPartOfStaticList(theKeyName) == -1;
}

void KernelManagerContour::deleteCModel(std::string theKeyName){
	manualBaseModel* cModel		= modelManager->getOutlineByKeyName(theKeyName)->getModel();
	modelManager->removeOutline( theKeyName );

	delete cModel;
}

void KernelManagerContour::removeAllOutlines(){
	modelManager->removeAllOutlines();
}

std::vector<NameWrapper *> KernelManagerContour::getActualInstantOutlines(){
	return modelManager->getActualInstantOutlines();
}

int KernelManagerContour::getNamesWrappingSize(){
	return getActualInstantOutlines().size();
}

std::string KernelManagerContour::getNameWrapping(int i){
	return getActualInstantOutlines()[i]->getKeyName();
}

void KernelManagerContour::setInstant(Instant * theInstant){
	modelManager->setInstant(theInstant);
	//_actualInstant = theInstant;
}

Instant * KernelManagerContour::getCurrentInstant(){
	return modelManager->getInstant();
}
void KernelManagerContour::setInstant(std::vector<int> vectInstant){
	Instant* act = new Instant ( &vectInstant );
	modelManager->setInstant(act);
}

std::string KernelManagerContour::createCopyContourOf ( std::string anExistingKName, std::vector<int> &instantNoTouchData)
{
	return modelManager->createCopyContourOf(anExistingKName, instantNoTouchData);
}

manualBaseModel* KernelManagerContour::getOutlineByKeyName(std::string cloneName)
{
	return modelManager->getOutlineByKeyName (cloneName )->getModel();
}

bool KernelManagerContour::onRedo(std::string& filename){
	if(inredo > 0){
		inredo--;
		inundo++;
		std::string str = intToString(inundo);
		filename = stundoredo + str + ".roi";
		//loadState(temp);
		return true;
	}
	return false;
}

bool KernelManagerContour::onUndo(std::string& filename){
	if(inundo>0){
		inredo++;
		inundo--;

		//char str[9000];
		//itoa(inundo, str, 10);
		std::string str = intToString(inundo);


		filename = stundoredo + str + ".roi";

		return true;//loadState(temp);
	}
	return false;
}

std::string KernelManagerContour::saveState(){
	inredo=0;
	std::string str = intToString(inundo);
	std::string temp = stundoredo + str + ".roi";
	inundo++;
	return temp;
}

bool KernelManagerContour::onUndoSaveFile(std::string& filename){
	if(inundo>0){
		if(inredo==0){

			//char str[9000];
			//itoa(inundo, str, 10);
			std::string str = intToString(inundo);

			filename = stundoredo + str + ".roi";
			return true;
			//saveFileWithContours(temp);

		}
	}
	return false;
}

void KernelManagerContour :: changeContourOfManager(std::string keyName, Instant *instant)
{
	modelManager->ChangeContourOfList(keyName, instant);
}

void KernelManagerContour ::resetAppend()
{
    if (_contourPropagation!=NULL)
	{
		_contourPropagation->resetAppend();
	}
}


std::string KernelManagerContour::onSpreadAdd( std::vector<double> *vecX, std::vector<double> *vecY, std::vector<double> *vecZ, std::vector<int> instants)
{
    if (_contourPropagation==NULL)
    {
  		_contourPropagation = new ContourPropagation();
    }

    if (vecX->size()!=0){

        int i,size=vecZ->size();
        int actualSlice = instants[1];
        for ( i=0 ; i<size ; i++ )
        {
            (*vecZ)[i] = actualSlice;
        } // for

        _contourPropagation->appendContour(vecX , vecY , vecZ);
        return intToString(actualSlice);
    }
	return "";
}


void KernelManagerContour::getMaxMinZ(double *minZ,double *maxZ)
{
    if (_contourPropagation!=NULL)
	{
		_contourPropagation->getMaxMinZ(minZ, maxZ);
	}
}


void KernelManagerContour::CalculeSplinePropagation()
{
	_contourPropagation->setInterpolationNumber(100);
	_contourPropagation->CalculeSplinePropagation();
}

manualBaseModel* KernelManagerContour::GetPoints(int z,int type, std::vector<double>* vecCtrlPointX,std::vector<double>* vecCtrlPointY,std::vector<double>* vecCtrlPointZ, std::string& theName,int typeofcontour, std::vector<int> tempVector)
{
	bool addedModel = false;
	manualBaseModel* manModelContour=NULL;

	if (_contourPropagation->ifSliceKeyContourExist(z)==false){

		manModelContour = factoryManualContourModel( typeofcontour );

		int idTmp = _contourPropagation->FindIdWithZ(z);

		if (type==0) // Initial Points
		{
			_contourPropagation->GetInitialControlPoints( idTmp , vecCtrlPointX,vecCtrlPointY,vecCtrlPointZ);
		}
		if (type==1)  // Automatique Method
		{
			_contourPropagation->GetControlPoints( idTmp  ,vecCtrlPointX,vecCtrlPointY,vecCtrlPointZ);
		}
		if (type==2)  // sampling
		{
			_contourPropagation->GetControlPoints( idTmp , 20.0 ,vecCtrlPointX,vecCtrlPointY,vecCtrlPointZ);
		}
//--------------------------------------------------------------------
		int sizeCtrPt = vecCtrlPointX->size();
		for (int j=0 ; j<sizeCtrPt ; j++)
		{
//JSTG_16-07-08_----------------------------------------------------------------
			manModelContour->AddPoint( (*vecCtrlPointX)[j] , (*vecCtrlPointY)[j] , -900  );
//--------------------------------------------------------------------
		} // for j

		tempVector[1]=z;
		theName = modelManager->createOutline( manModelContour, tempVector );
		addedModel = theName.compare("") != 0;
		if(!addedModel){
			manModelContour = NULL;
		}

	}// ifSliceKeyContourExist
	return manModelContour;
}

manualBaseModel * KernelManagerContour::factoryManualContourModel(int typeContour)
{
	manualBaseModel *manModelContour=NULL;

	// Creating the model
	// NOTE: The view and the controler are created in the wxVtkBaseView_SceneManager class, configureViewControlTo method

	// spline
	if (typeContour==0)
	{
		manModelContour = new manualContourModel();
	}

	// spline
	if (typeContour==1)
	{
		manModelContour = new manualContourModel();
	}

	// rectangle
	if (typeContour==2)
	{
		manModelContour = new manualContourModelRoi();
	}

	// circle
	if (typeContour==3)
	{
		manModelContour = new manualContourModelCircle();
	}

	// line
	if (typeContour==6)
	{
		manModelContour = new manualContourModelLine();
	}

	// points
	if (typeContour==7)
	{
		manModelContour = new manualBaseModel();
	}

	// polygon
	if (typeContour==10)
	{
		manModelContour = new manualContourModelPolygon();
	}

	return manModelContour;
}

std::vector<std::string> KernelManagerContour::getOutlinesNameAtInstant(std::vector<int> tempvector){
	Instant instant(&tempvector);
	std::vector<ContourThing**> vectcont = modelManager->getOutlinesAtInstant( &instant );
	std::vector<std::string> vectname;
	for(int i = 0; i < (int)(vectcont.size()); i++){
		ContourThing **contourthing = vectcont[i];
		vectname.push_back((*contourthing)->getName());
	}
    return vectname;
}

std::vector<ContourThing**> KernelManagerContour::getOutlinesAtInstant(Instant* instant ){
	return modelManager->getOutlinesAtInstant(instant);
}

std::vector<manualBaseModel*> KernelManagerContour::ExploseEachModel( std::vector<manualBaseModel*> lstManConMod ){
	std::vector<manualBaseModel*> lstTmp;
	std::vector<manualBaseModel*> lstResult;
	int j,jSize;
	int i,iSize=lstManConMod.size();
	for (i=0;i<iSize;i++)
	{
		lstTmp = lstManConMod[i]->ExploseModel();
		jSize=lstTmp.size();
		for (j=0;j<jSize;j++)
		{
			lstResult.push_back( lstTmp[j] );
		}
	}
	return lstResult;
}

void KernelManagerContour::getConceptsInformation(std::vector<std::string>& conceptNameVect, std::vector<int>& conceptSizeVect){
	modelManager-> getConceptsInformation(conceptNameVect, conceptSizeVect);
}


vtkImageData* KernelManagerContour::getImageAtInstant(std::vector<int> inst){
	int index = inst[5]-1;

	if(index < (int)(vectimages.size())&&index!=_currentIndex){
		_currentIndex=index;
		return vectimages[index];
	}
	return NULL;
}

std::string KernelManagerContour::getCurrentFileName(){
	return filename;
}

void KernelManagerContour::setCurrentFileName(std::string filenam){
	this->filename = filenam;
}

std::string KernelManagerContour::parseOsirixFile(std::string filename){


#ifdef ParserOsirix_BUILD
	vtkImageData* sourceimage;
	std::string xsdfile;

	xsdfile = _datadir;

	xsdfile.append("\\XML\\osirixschema.xsd");

	sourceimage = getSourceImage();
	OsirixParser p(xsdfile.c_str(), sourceimage->GetSpacing(), sourceimage->GetExtent());

	if(p.ParseFile(filename.c_str())!= 0){

	}

	return p.getContoursFileName();
#else
	return "";
#endif


}


