/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "KeyThing.h"


//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file KeyThing.cxx */


	/*
	* Creates the key thing	
	* @param thePrefix Is the prefix of the new keyThing for the key generation correponding to the new keyThing
	* @param theValue Is the value of the intial key generation correponding to the new keyThing
	*/
	KeyThing :: KeyThing(std::string thePrefix, int theValue)
	{
		setPrefix( thePrefix );
		setValue( theValue );
	}

	/*
	* Destroys the key thing	
	*/
	KeyThing :: ~KeyThing()
	{

	}

	
//------------------------------------------------------------------------------------------------------------
// Public Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* Sets the prefix of the keyThing
	*/
	void KeyThing :: setPrefix( std::string aPrefix)
	{
		prefix = aPrefix;
	}
	
	/*
	* Sets the value value of the keyThing
	* @param aValue The valueimum to set
	*/
	void KeyThing :: setValue (int aValue)
	{
		value = aValue;
	}

	/*
	* Gets the prefix of the keyThing
	* @return prefix The setted prefix
	*/
	std::string KeyThing :: getPrefix()
	{
		return prefix;
	}
	
	/*
	* Gets the value value of the keyThing
	* @return value The setted valueimum
	*/
	int KeyThing :: getValue()
	{
		return value;
	}
 
 
