/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#ifndef __KEY_THING__
#define __KEY_THING__


//------------------------------------------------------------------------------------------------------------
// Includes
//------------------------------------------------------------------------------------------------------------
#include <iostream>
#include <string>

class KeyThing{

	
//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------
public:

	/*
	* Creates the key thing	
	* @param thePrefix Is the prefix of the new keyThing for the key generation correponding to the new keyThing
	* @param theValue Is the value of the intial key generation correponding to the new keyThing
	*/
	KeyThing(std::string thePrefix, int theValue);

	/*
	* Destroys the key thing	
	*/
	~KeyThing();

	
//------------------------------------------------------------------------------------------------------------
// Public Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* Sets the prefix of the keyThing
	*/
	void setPrefix( std::string aPrefix);
	
	/*
	* Sets the value value of the keyThing
	* @param aValue The valueimum to set
	*/
	void setValue (int aValue);

	/*
	* Gets the prefix of the keyThing
	* @return prefix The setted prefix
	*/
	std::string getPrefix();
	
	/*
	* Gets the value value of the keyThing
	* @return value The setted valueimum
	*/
	int getValue();

//------------------------------------------------------------------------------------------------------------
// Constants
//------------------------------------------------------------------------------------------------------------

//------------------------------------------------------------------------------------------------------------
// Attributes
//------------------------------------------------------------------------------------------------------------
	
private: 	

	/*
	* Represents the prefix of the keyThing
	*/
	std::string prefix;
	
	/*
	* Represents the value value of the keyThing
	*/
	int value;
};
#endif

