/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "NameWrapper.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file NameWrapper.cxx */

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------

	/*
	* Creates the NameWrapper
	* @param thekeyName The key name
	* @param theRealName  The real name
	* @return Returns the created NameWrapper 
	*/
	NameWrapper :: NameWrapper(std::string thekeyName, std::string theRealName)
	{
		setWrappingPair(thekeyName, theRealName);
	}

	/*
	* Destroys the NameWrapper
	*/
	NameWrapper :: ~ NameWrapper()
	{

	}

//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/*
	* Sets the names pair to wrapp
	* @param thekeyName The key name
	* @param theRealName  The real name
	*/
	void NameWrapper :: setWrappingPair(std::string thekeyName, std::string theRealName )
	{
		realName = theRealName;
		keyName = thekeyName;
	}

	/*
	* Gets the wrapped key name
	* @param keyName The key name
	*/
	std::string NameWrapper :: getKeyName()
	{
		return keyName;
	}

	/*
	* Gets the wrapped real name
	* @param realName The real name
	*/
	std::string NameWrapper :: getRealName()
	{
		return realName;
	}
 
 
