/*# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


//----------------------------------------------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------------------------------------------
#include "OutlineModelBuilder.h"

//----------------------------------------------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------------------------------------------
/** @file OutlineModelBuilder.cxx */

//------------------------------------------------------------------------------------------------------------
// Constructors & Destructors
//------------------------------------------------------------------------------------------------------------

	/**
	* Creates an OutlineModelBuilder
	* @ param filesNames Paired set of files with the names of the files to read ConceptsFile, ImageSourcesFile, ImageSectionsFile, AxeThingsFile, ContoursFile
	* @ param sources Paired set of sourceKeyName-ImageSourceThing
	* @ param sections Paired set of sectionKeyName-ImageSectionThing
	* @ param axes Paired set of axeKeyName-AxeThing
	* @ param outlines Paired set of contoKeyName-ContourThing
	*/
OutlineModelBuilder ::  OutlineModelBuilder(std::string  theConceptsFile, std::string datadir)//std::map<std::string, std::string> filesNames, std::map<std::string, ImageSourceThing *> * sources, std::map<std::string, ImageSectionThing *>* sections, std::map<std::string, AxeThing *>* axes, std::map<std::string, ContourThing *>* outlines)
	{
		conceptsFile = theConceptsFile;	
		imagesSectionEnvOtherConceptsFN = datadir + "/imageSectionOtherConceptsFile.cf";//"C:/Creatis/Maracas/src/interface/wxWindows/NDimension/data/imageSectionOtherConceptsFile.cf";
		outlinesEnvOtherConceptsFN = datadir + "/outlinesOtherConceptsFile.cf";//"C:/Creatis/Maracas/src/interface/wxWindows/NDimension/data/outlinesOtherConceptsFile.cf";
		axesEnvOtherConceptsFN = datadir + "/axesOtherConceptsFile.cf";//"C:/Creatis/Maracas/src/interface/wxWindows/NDimension/data/axesOtherConceptsFile.cf";
		axesEnv_Reader = NULL;
		imagesSectionEnv_Reader = NULL;
		imageSourceEnv_Reader = NULL;
		outlinesEnv_Reader = NULL;
	}

	/**
	* Destroys an AxeThing
	*/
	OutlineModelBuilder ::  ~OutlineModelBuilder()
	{
		delete axesEnv_Reader;
		delete imagesSectionEnv_Reader;
		delete imageSourceEnv_Reader;
		delete outlinesEnv_Reader;
	}
//------------------------------------------------------------------------------------------------------------
// Methods
//------------------------------------------------------------------------------------------------------------

	/**
	* Gets the ImageSourceThing environment
	*@param  ImSourceEnv 
	*/
    SomeEnvironment<ImageSourceThing *> * OutlineModelBuilder ::  getImSourceEnv()
	{
		return ( imageSourceEnv_Reader!= NULL ) ? imageSourceEnv_Reader->getEnvironment() : new SomeEnvironment<ImageSourceThing *>();
	}
	/**
	* Gets the ImageSectionThing environment
	*@param  imSectionEnv 
	*/
	SomeEnvironment<ImageSectionThing *> * OutlineModelBuilder ::  getImSectionEnv()
	{
		return ( imagesSectionEnv_Reader!= NULL ) ? imagesSectionEnv_Reader->getEnvironment() : new SomeEnvironment<ImageSectionThing *>();
	}
	/*
	* Gets the AxeThing environment
	*@param  AxesEnv
	*/
	SomeEnvironment<AxeThing *> * OutlineModelBuilder ::  getAxesEnv()
	{
		return ( axesEnv_Reader!= NULL ) ? axesEnv_Reader->getEnvironment() : new SomeEnvironment<AxeThing *>();
	}
	/**
	* Gets the ContourThing environment
	*@param  ContourEnv 
	*/
	SomeEnvironment<ContourThing *> * OutlineModelBuilder ::  getContourEnv()
	{
		return ( outlinesEnv_Reader!= NULL ) ? outlinesEnv_Reader->getEnvironment() : new SomeEnvironment<ContourThing *>();
	}


	/**
	* Builds the ImageSourceThing * environment
	* @param sourcesFile File path with the object key names and specific instants for each one
	* @param sources The sources to include in the enivorment
	*/
	void OutlineModelBuilder :: buildImageSource_Envornment( std::string sourcesFile, std::map<std::string, ImageSourceThing *> * sources )
	{
		if( !conceptsFile.empty() )
			imageSourceEnv_Reader = new ReaderEnvironment<ImageSourceThing *> (conceptsFile, sourcesFile, sources);
			//imageSourceEnv_Reader = new ReaderEnvironment<ImageSourceThing *> ("data/holaConceptsFile.cf", sourcesFile, sources);
	}

	/**
	* Builds the ImageSectionThing * environment
	* @param sectionsFile File path with the object key names and specific instants for each one
	* @param sections The sections to include in the enivorment
	*/
	void OutlineModelBuilder :: buildImageSection_Envornment( std::string sectionsFile, std::map<std::string, ImageSectionThing *>* sections )
	{
		if( !conceptsFile.empty() )
			imagesSectionEnv_Reader = new ReaderEnvironment<ImageSectionThing *> ( imagesSectionEnvOtherConceptsFN, conceptsFile, sectionsFile, sections);
	}


	/**
	* Builds the AxeThing * environment
	* @param axesFile File path with the object key names and specific instants for each one
	* @param axes The axes to include in the enivorment
	*/
	void OutlineModelBuilder :: buildAxe_Envornment( std::string axesFile, std::map<std::string, AxeThing *>* axes )
	{
		if( !conceptsFile.empty() )
			axesEnv_Reader = new ReaderEnvironment<AxeThing *> ( axesEnvOtherConceptsFN, conceptsFile, axesFile, axes);
	}

	/**
	* Builds the CountourThing * environment
	* @param outlinesFile File path with the object key names and specific instants for each one
	* @param outlines The outlines to include in the enivorment
	*/
	void OutlineModelBuilder :: buildCountour_Envornment( std::string outlinesFile, std::map<std::string, ContourThing *>* outlines )
	{
		if( !conceptsFile.empty() )
			outlinesEnv_Reader = new ReaderEnvironment< ContourThing *> ( outlinesEnvOtherConceptsFN, conceptsFile, outlinesFile, outlines);
	}

