/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
#include <creaImageIOSystem.h>
#include <creaImageIOGimmickReaderDialog.h>
#include <creaVtkBasicSlicer.h>
#include <iostream>

int main(int argc, char* argv[])
{	
  if (argc>1)
    {
      int l = atoi(argv[1]);
      creaImageIO::SetGimmickMessageLevel(l);
    }

  std::vector<vtkImageData*> images;  
  bool r = creaImageIO::GimmickReaderDialog(images,
					    "GimmickReaderDialog test",
						"localdatabase_Descriptor.dscp",
				        "Local Database",
					    0,0,800,800,2,3,3,1);
  
  if (r)
    {
      std::cout << "$$$$ main : user clicked 'OK' $$$$"<<std::endl;
      crea::VtkBasicSlicer(images.front());
      images.front()->Delete();
     }
  else 
    {
      std::cout << "$$$$ main : user clicked 'CANCEL' $$$$"<<std::endl;
     }
}
