/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
#include <creaImageIOSystem.h>
#include <creaWx.h>
#include <creaImageIOWxGimmickReaderDialog.h>
#include "vtkMetaImageWriter.h"
#include "vtkMetaImageReader.h"
#include <creaVtkBasicSlicer.h>




//#pragma comment(lib, "creaImageIO.lib")
//#pragma comment(lib, "DelayImp.lib")
//
//
//// Tell the linker that my DLL should be delay loaded
////#pragma comment(linker, "/DelayLoad:creaImageIO.Dll")
//
//// Tell the linker that I want to be able to unload my DLL
//#pragma comment(linker, "/Delay:unload")
//

class myApp : public wxApp
{
public:
  bool OnInit( );
  int  OnExit() { return true; }
};

IMPLEMENT_APP(myApp);

CREA_WXMAIN_WITH_CONSOLE



bool myApp::OnInit( )
{
  wxApp::OnInit();
#ifdef __WXGTK__
  //See http://www.wxwindows.org/faqgtk.htm#locale
  setlocale(LC_NUMERIC, "C");
#endif
   wxInitAllImageHandlers();

   creaImageIO::SetGimmickMessageLevel(5);
   creaImageIO::SetGimmickDebugMessageLevel(0);

   int min_dim = GIMMICK_2D_IMAGE_SELECTION;
   int max_dim = GIMMICK_3D_IMAGE_SELECTION;

//EED
//   int output_dim = NATIVE;
   int output_dim = _3D;

   int threads = 1;
 
   creaImageIO::WxGimmickReaderDialog w(
                    0,
                   -1, 
				   "localdatabase_Descriptor.dscp",
				   "Local Database",
                   _T("Select image(s)        - creaImageIOApp  (c) CREATIS ( cnrs)"),
                   wxDefaultPosition,
                   wxSize(810,750),
                   min_dim,
                   max_dim,
                   output_dim,
       
				   threads);
  /* clock_t endwait;
		endwait = clock () +  CLOCKS_PER_SEC ;
		while (clock() < endwait ) {}*/
   w.ShowModal();

   if (w.GetReturnCode() == wxID_OK)
     {
       std::cout << "$$$$ main : user clicked 'OK' $$$$"<<std::endl;
       std::cout << "$$$$ selected files : "<<std::endl;
       //Puts filenames
       std::vector<std::string> s;
       w.GetSelectedFiles(s);
       std::vector<std::string>::iterator i;
       for (i=s.begin();i!=s.end();++i) 
         {
           std::cout << *i << std::endl;
         }
       std::cout << "$$$$ "<<std::endl;

       //Puts images
    /*   std::vector<vtkImageData*> images;
	   w.GetSelectedImages(images,3);*/

	
	// First Exemple:
	// We take all attributes from database
	// but only for the first selected file.
    // For the moment, no output model file (XML)
	//  std::vector<creaImageIO::OutStrGimmick> out;
	//  std::vector<std::string> attr;
	//  attr.push_back("ALL");
	//  w.getSelected(out, attr, false,"");


    // Second Exemple:
	// We take all attributes from database
	// but for all selected file.
    // For the moment, no output model file (XML)
	//  std::vector<creaImageIO::OutStrGimmick> out;
	//  std::vector<std::string> attr;
	//  attr.push_back("ALL");
	//  w.getSelected(out, attr,true,"");

    // Third Exemple:
	// We take attributes from database and others
	// but for all selected file.
    // For the moment, no output model file (XML)
	   std::vector<creaImageIO::OutStrGimmick> out;
       std::vector<std::string> attr;
	   attr.push_back("D0028_0010");
	   attr.push_back("D0008_0023");
	   attr.push_back("D0008_1070");
	   w.getSelected(out, attr,true,"");
       std::cout<<out.size()<<std::endl;
	   crea::VtkBasicSlicer(out.front().img);
       out.front().img->Delete();
       w.OnExit();


// images[1]->UpdateInformation();
	/*   vtkMetaImageReader *r= vtkMetaImageReader::New();
		   r->SetFileName("c:\\toto.mhd");
	   double zz[3];
		 images[0]->GetSpacing(zz);

	   vtkMetaImageWriter* ww = vtkMetaImageWriter::New(); 
	   	 ww->SetFileName("c:\\toto2.mhd"); 
		 ww->SetInput(images[0]);
		 ww->GetInput()->ShallowCopy(images[0]);
		 ww->UpdateInformation();
		 ww->GetInput()->GetSpacing(zz);
		 

//>GetImageDataInput(0)->GetSpacing(zz);
	 images[0]->Delete();
	
    ww->Write(); 
   ww->Delete();
*/




	   //crea::VtkBasicSlicer(out.front().img);
    //   images.front()->Delete();
    //   w.OnExit();

     }
   else if (w.GetReturnCode() == wxID_CANCEL)
     {
		
       w.OnExit();
       std::cout << "$$$$ main : user clicked 'CANCEL' $$$$"<<std::endl;
     }
   else 
     {
       w.OnExit();
       std::cout << "$$$$ main : dialog ended without return code ! $$$$"
                 <<std::endl;    
     }


   //   std::cout << "$$$$ main : deleting dialog"<<std::endl;
   //   delete w;
   std::cout << "$$$$$$$$$$$$$$$$$$$$ main ended "<<std::endl;
   return false;
}
