/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
#include <creaImageIOSystem.h>
#include <creaWx.h>
#include <creaImageIOWxISimpleDlg.h>
#include <creaImageIOWxISimpleDlg.hpp>
#include <itkImageBase.h>
#include <creaVtkBasicSlicer.h>

#define ITK_DIM_TO_TEST 4

// Just to test the selection of file(s), directory or from creaImageIO database.
class myApp : public wxApp
{
public:
  bool OnInit( );
  int  OnExit() { return true; }
};

IMPLEMENT_APP(myApp);

CREA_WXMAIN_WITH_CONSOLE

bool myApp::OnInit( )
{
  wxApp::OnInit();
#ifdef __WXGTK__
  //See http://www.wxwindows.org/faqgtk.htm#locale
  setlocale(LC_NUMERIC, "C");
#endif
   wxInitAllImageHandlers();
   std::vector <vtkImageData*> vtktest;
   std::vector<std::string> exts;
   vtkImageData* im = vtkImageData::New();
  if(ITK_DIM_TO_TEST == 3)
   {
   
	   typedef itk::Image<short, ITK_DIM_TO_TEST >  ImageType;
	   creaImageIO::WxISimpleDlg<ImageType> x(0);
	   // files extension to take in count
       exts.push_back(".hdr");
       x.setExts(exts);
       x.ShowModal();
	   // get itkImage vector
	   std::vector <ImageType::Pointer> test = x.getImagesSelected();
	   // convert 3D itk to 3D vtk
	   x.split3Din3Dvtk();
	   vtktest = x.getVtkImagesSelected();
	  if(vtktest.size() >0)
	  {
		crea::VtkBasicSlicer(vtktest.front());
	  }
  }
  else if (ITK_DIM_TO_TEST == 4)
  {
	  typedef itk::Image<short, ITK_DIM_TO_TEST >  ImageType;
      creaImageIO::WxISimpleDlg<ImageType> x(0);
	  x.ShowModal();
	  // get itkImage vector
	  std::vector <ImageType::Pointer> test = x.getImagesSelected();
	  // convert 4D itk to 3D vtk  with a directory to create tempory vtk files.
      x.split4Din3Dvtk("d:/temp2");
	  // get vtkImageData* vector
	  vtktest = x.getVtkImagesSelected();
	  if(vtktest.size() >0)
	  {
		crea::VtkBasicSlicer(vtktest.front());
	  }
	}
   
  else{}

 
  
   return false;
}


