/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
#include <creaWx.h>
#include <creaImageIOWxGimmickFrame.h>

class myApp : public wxApp
{
public:
  bool OnInit( );
  int  OnExit() { return true; }
};

IMPLEMENT_APP(myApp);

CREA_WXMAIN_WITH_CONSOLE

bool myApp::OnInit( )
{	 
  wxApp::OnInit();
#ifdef __WXGTK__
  //See http://www.wxwindows.org/faqgtk.htm#locale
  setlocale(LC_NUMERIC, "C");
#endif
   wxInitAllImageHandlers();

   
   creaImageIO::SetGimmickMessageLevel(5);
   creaImageIO::SetGimmickDebugMessageLevel(5);
   

   int threads = 1;

   creaImageIO::WxGimmickFrame* f = new
     creaImageIO::WxGimmickFrame(0,
				 -1,
				 _T("wxGimmick! (c) CREATIS-LRMN 2008"),
				 wxDefaultPosition,
				 wxSize(1200,800),
				 threads);
   f->Show();
   
   return true;
}


