/*
	# ---------------------------------------------------------------------
	#
	# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
	#                        pour la Sant)
	# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
	# Previous Authors : Laurent Guigues, Jean-Pierre Roux
	# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
	#
	#  This software is governed by the CeCILL-B license under French law and 
	#  abiding by the rules of distribution of free software. You can  use, 
	#  modify and/ or redistribute the software under the terms of the CeCILL-B 
	#  license as circulated by CEA, CNRS and INRIA at the following URL 
	#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
	#  or in the file LICENSE.txt.
	#
	#  As a counterpart to the access to the source code and  rights to copy,
	#  modify and redistribute granted by the license, users are provided only
	#  with a limited warranty  and the software's author,  the holder of the
	#  economic rights,  and the successive licensors  have only  limited
	#  liability. 
	#
	#  The fact that you are presently reading this means that you have had
	#  knowledge of the CeCILL-B license and that you accept its terms.
	# ------------------------------------------------------------------------
*/
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 

#include "bbcreaImageIOItkImagesChooserDialogBox.h"
#include "bbcreaImageIOPackage.h"

namespace bbcreaImageIO
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(creaImageIO,ItkImagesChooserDialogBox)
BBTK_BLACK_BOX_IMPLEMENTATION(ItkImagesChooserDialogBox,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ItkImagesChooserDialogBox::Process()
{
 
    dlg = new creaImageIO::WxAnySimpleDlg(0,crea::std2wx(bbGetInputTitle()),"localdatabase_Descriptor.dscp","Local Database"); 
    dlg->ShowModal(); 

    bbtk::TypeInfo typ = bbitk::GetITKImagePtrTypeInfoFromPixelTypeInfoAndDimension(*dlg->getTypes().front(), dlg->getDims().front());
    BBTK_TEMPLATE_ITK_IMAGE_SWITCH(typ, Export);
    BBTK_TEMPLATE_ITK_IMAGE_SWITCH(typ, ExportVTK);

    delete dlg;
}

template <class TImage>
void ItkImagesChooserDialogBox::Export()
{
   if (dlg->getImagesSelected().size() == 1)
   { 
		bbSetOutputOut( dlg->getTemplatedImagesSelected<TImage>().front().GetPointer() ); 
   } 
   else if (dlg->getImagesSelected().size() > 1)
   { 
      OutputImagesITKType outVect;

      typename  std::vector<typename TImage::Pointer> tempImgs= dlg->getTemplatedImagesSelected<TImage>();
      typename std::vector<typename TImage::Pointer>::iterator it = tempImgs.begin();
      for(;it != tempImgs.end(); ++it)
      {
         outVect.push_back( (*it).GetPointer() );
      }
      bbSetOutputOutIImages( outVect); 
   } 
   else
   {
      // warning: passing NULL to non-pointer 
      //bbSetOutputOut( NULL);
      bbSetOutputOut(0); // JPR
   }
	 // FCY To test the Output
	  //typedef itk::Image <short, 3> ImageType;
	 //typedef itk::ImageFileReader< ImageType > itkReaderType;
     //  typename itkReaderType::Pointer reader = itkReaderType::New();
     //
     //  reader->SetFileName("d:\test.hdr");
     //   reader->Update(); 
	 //reader->GetOutput()->Register();
     //  this->bbSetOutputOut(reader->GetOutput());
}
template <class TImage>
void ItkImagesChooserDialogBox::ExportVTK()
{
	// BBTK can support only a vector with same dimensions image.
	 if (dlg->getDims().front() < 4)
	 { 
		  typename std::vector<typename TImage::Pointer> tempImgs= dlg->getTemplatedImagesSelected<TImage>();
		  typename std::vector<typename TImage::Pointer>::iterator it = tempImgs.begin();
		  for(;it != tempImgs.end(); ++it)
		  {
			dlg->split3Din3Dvtk<TImage>( (*it) );
		  }
		  bbSetOutputOutVImages( dlg->getVtkImagesSelected() ); 
	 } 
	 else if (dlg->getDims().front() == 4)
	 { 
		// To Test
		 //  dlg->split4Din3Dvtk("d:/temp2");
		 // bbSetOutputOutVImages( dlg->getVtkImagesSelected()); 
         } 
	 else
	 {
		  // NOT IMPLEMENTED YET FOR DIMENSIONS > 4
	
	 }
	 
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ItkImagesChooserDialogBox::bbUserSetDefaultValues()
{
 
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ItkImagesChooserDialogBox::bbUserInitializeProcessing()
{

}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void ItkImagesChooserDialogBox::bbUserFinalizeProcessing()
{

}
}
// EO namespace bbcreaImageIO
