/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIODicomImageReader.h>
#include <vtkGdcmReader.h>
#include <creaImageIOSystem.h>
#include "boost/filesystem/path.hpp"

#include <creaImageIOTreeAttributeDescriptor.h>
#include <vtkStringArray.h>
#include <creaImageIOGimmick.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#endif
namespace creaImageIO
{

  //=====================================================================
  DicomImageReader::DicomImageReader()
  {
    mReader = vtkGdcmReader::New();
	  
//EED 21 mars 2012  FLIP probleme  ..PLOP..
	mReader->SetFlipY(false);
	  
    SetName ( "Dicom" );

  };
  //=====================================================================
  
  //=====================================================================
  DicomImageReader::~DicomImageReader()
  {
    mReader->Delete();
  }
  //=====================================================================

  //=====================================================================  
  bool DicomImageReader::CanRead(const std::string& filename)
  { 
    GDCM_NAME_SPACE::Document*doc;
    GDCM_NAME_SPACE::File* file = GDCM_NAME_SPACE::File::New();
    file->SetLoadMode( GDCM_NAME_SPACE::LD_ALL);
    file->SetFileName(filename.c_str());
    file->Load();
    bool ok = file->IsReadable();
	if(!ok)
	{
		doc = (GDCM_NAME_SPACE::Document*)file;	
		ok = doc->IsReadable();
	}
    file->Delete();
    return ok;
  }
  //=====================================================================

  //=====================================================================
  vtkImageData* DicomImageReader::ReadImage(const std::string& filename)
  {
    vtkImageData* im = 0;
    try
      {
	mReader->SetFileName(filename.c_str());
	mReader->Update();
	im = vtkImageData::New();
	im->ShallowCopy(mReader->GetOutput());
      }
    catch (...)
      {
	if (im!=0) im->Delete();
	  im = 0;
      }
    return im;
  }

  //=====================================================================
  void DicomImageReader::PushBackExtensions(std::vector<std::string>& v)
  {
    v.push_back("dcm");
    v.push_back("");
  }
  //=====================================================================
  
  //========================================================================
  std::string irclean(const std::string& str)
  {
	  if(str.size() > 0)
	  {
		if (str == "GDCM::Unfound") 
		  {
		return "";
		  }
		if (str[str.size()-1]==' ')
		  {
		return irclean(str.substr(0,str.size()-1));
		  }
		if (str[str.size()-1]==0)
		  {
		return irclean(str.substr(0,str.size()-1));
		  }
	  }
    
    return str;
  }
  //========================================================================
  void DicomImageReader::getAttributes(const std::string filename,
		std::map <std::string , std::string> &infos, std::vector<std::string> i_attr)
	{
		std::vector<std::string>::iterator it = i_attr.begin();
		for(; it != i_attr.end(); it++)
		{
			infos[(*it)] = "";
		}
		ReadAttributes(filename, infos);
	}
  //=====================================================================
  void DicomImageReader::ReadAttributes(const std::string& filename, 
		      std::map<std::string,std::string>& attr)
  {
    GimmickMessage(2,"Reading attributes from DICOM file '"
		   <<filename<<"'"<<std::endl);

    GDCM_NAME_SPACE::File* file = GDCM_NAME_SPACE::File::New();
	//boost::shared_ptr<GDCM_NAME_SPACE::File> file(GDCM_NAME_SPACE::File::New());//, DicomImageReader::deleter());

    GDCM_NAME_SPACE::Document *doc= GDCM_NAME_SPACE::File::New();
    doc->SetLoadMode( GDCM_NAME_SPACE::LD_ALL);
    doc->SetFileName(filename.c_str());
    doc->Load();
    file->SetLoadMode( GDCM_NAME_SPACE::LD_ALL);
    file->SetFileName(filename.c_str());
    file->Load();
    if (file->IsReadable())// ||((GDCM_NAME_SPACE::Document*) file)->IsReadable())
      {
	std::map<std::string,std::string>::iterator i;
	for (i=attr.begin();i!=attr.end();++i)
	  {
	    if ( i->first == "D0004_1500" )
	      {
		boost::filesystem::path full_path(filename);
		std::string f = full_path.leaf().string();
		i->second = f;
	      }
	    else if ( i->first == "FullFileName" )
	      {
		i->second = filename;
	      }
		  else if ( i->first == "FullFileDirectory" )
	      {
			  std::string::size_type last_pos = filename.find_last_of("//");
			  //find first separator
			  i->second = filename.substr(0, last_pos);
	      }
	    else
	      {
		uint16_t el;
		uint16_t gr;
		
		tree::AttributeDescriptor::GetDicomGroupElementFromKey(i->first,gr,el);
		if ( ( gr!=0 ) && ( el!=0 ) )
		  {
		    std::string val =  file->GetEntryString(gr,el);
		    i->second = irclean(val);
		  }
	      }
	  }
      }
  }

  //=====================================================================
  
} // namespace creaImageIO

