/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include "creaImageIODicomImageReader2.h"
#include <creaImageIOTreeAttributeDescriptor.h>
#include "gdcmStringFilter.h"
#include "gdcmUIDs.h"
#include "boost/filesystem/path.hpp"

#include "vtkGDCMImageReader.h"
#include <vtkStringArray.h>
#if defined(_WIN32)
#pragma warning(disable: 4996)
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif
namespace creaImageIO
{

  //=====================================================================
  DicomImageReader::DicomImageReader()
  {
      mReader =  vtkGDCMImageReader::New();
      SetName ( "Dicom" );
	
  };
  //=====================================================================
  
  //=====================================================================
  DicomImageReader::~DicomImageReader()
  {
      mReader->Delete();
  }
  //=====================================================================

  //=====================================================================  
  bool DicomImageReader::CanRead(const std::string& filename)
  { 
      gdcm::Reader reader;
      reader.SetFileName( filename.c_str() );
      return  reader.Read();
  	 
  }
  //=====================================================================

  //=====================================================================
  vtkImageData* DicomImageReader::ReadImage(const std::string& filename)
  {
    vtkImageData* im = 0;
    try
      {
	mReader->SetFileName(filename.c_str());
	mReader->Update();
	im = vtkImageData::New();
	im->ShallowCopy(mReader->GetOutput());
      }
    catch (...)
      {
	if (im!=0) im->Delete();
	  im = 0;
      }
    return im;
    //gdcm::Tag grouplength(0x0000,0x0000);
    //gdcm::DataElement de(gdcm::Tag(0x0000, 0x0000));
    //de.SetByteValue("0",gdcm::VR::UL);
    //
    //
    //gdcm::UIDs::GetUIDString(gdcm::UIDS::uid_1_2_840_10008_1_1),gdcm::VR::UI);

    //std::ostream os;
    //de.Write(&os);

  }

  //=====================================================================
  void DicomImageReader::PushBackExtensions(std::vector<std::string>& v)
  {
    v.push_back("dcm");
    v.push_back("");
  }
 
  //========================================================================
  std::string irclean(const std::string& str)
  {
	  if(str.size() > 0)
	  {
		if (str == "GDCM::Unfound") 
		  {
		return "";
		  }
		if (str[str.size()-1]==' ')
		  {
		return irclean(str.substr(0,str.size()-1));
		  }
		if (str[str.size()-1]==0)
		  {
		return irclean(str.substr(0,str.size()-1));
		  }
	  }
    
    return str;
  }
  //========================================================================
  //=====================================================================
  

  	void DicomImageReader::getAttributes(const std::string filename, 
		std::map <std::string , std::string> &infos, std::vector<std::string> i_attr)
	{
		gdcm::Reader reader;
		reader.SetFileName( filename.c_str() );
		if (reader.Read())
		{
			std::vector<std::string>::iterator it = i_attr.begin();
			for(;it != i_attr.end(); it++)
			{
				unsigned short el;
				unsigned short gr;
				sscanf((*it).c_str(),"D%04hx_%04hx",&gr,&el);
				if ( ( gr!=0 ) && ( el!=0 ) )
				{
					infos[(*it)] =  ( GetStringValueFromTag(reader.GetFile().GetDataSet().GetDataElement(gdcm::Tag(gr,el))) );
				}
			}
		}
	}

  //=====================================================================
  void DicomImageReader::ReadAttributes(const std::string& filename, 
		      std::map<std::string,std::string>& attr)
  {

   
      gdcm::Reader reader;
      reader.SetFileName( filename.c_str() );
      if (reader.Read())
      {
		  gdcm::StringFilter sf;
		  sf.SetFile(reader.GetFile());
	  	  std::map<std::string,std::string>::iterator i;
		  for (i=attr.begin();i!=attr.end();++i)
	      {
			  if ( i->first == "D0004_1500" )
			  {
				  boost::filesystem::path full_path(filename);
				  std::string f = full_path.leaf().string();
				  i->second = f;
			  }
			  else if ( i->first == "FullFileName" )
			  {
				i->second = filename;
			  }
			  else if ( i->first == "FullFileDirectory" )
			  {
				 std::string::size_type last_pos = filename.find_last_of("//");
				 //find first separator
				 i->second = filename.substr(0, last_pos);
			  }
			  else
			  {
				  uint16_t el;
				  uint16_t gr;
                      {
            gdcm::Attribute<  0x0008,0x103e> at;
            std::string sr;
            at.SetValue(sr);
            
        }
				  tree::AttributeDescriptor::GetDicomGroupElementFromKey(i->first,gr,el);
				  //if ( ( gr!=0 ) && ( el!=0 ) )
				  const gdcm::Tag tag(gr, el);
				  if( reader.GetFile().GetDataSet().FindDataElement( tag ) )
				  {
					  i->second = irclean(sf.ToString(tag));
				  }
				  else
				  {
					  i->second = "";
				  }
			  }
		  }
	  }
  }

void DicomImageReader::ReadAttributes2(const std::string& filename, 
		      std::map<std::string,std::string>& attr)
  {
	if(!b_loaded)
	{
		std::map<std::string,std::string>::iterator i;
		for (i=attr.begin();i!=attr.end();++i)
		  {
			if ( i->first == "D0004_1500" ||  i->first == "FullFileName" || i->first == "FullFileDirectory" )
			{
			
			}
			else
			{
			uint16_t el;
			uint16_t gr;
			
			tree::AttributeDescriptor::GetDicomGroupElementFromKey(i->first,gr,el);
			mscan.AddTag(gdcm::Tag(gr,el) );
			}
		}
		b_loaded = true;
	}
	 bool b = mscan.IsKey(filename.c_str());
     if( b )
      {
		  const gdcm::Scanner::TagToValue &mapping = mscan.GetMapping(filename.c_str());
		  gdcm::Scanner::TagToValue::const_iterator it = mapping.begin();
		  std::map<std::string, std::string>::iterator i;
		for (i=attr.begin();i!=attr.end();++i, ++it)
		{
			if ( i->first == "D0004_1500" )
			{
				boost::filesystem::path full_path(filename);
				std::string f = full_path.leaf().string();
				i->second = f;
			}
			else if ( i->first == "FullFileName" )
			{
				i->second = filename;
			}
			else if ( i->first == "FullFileDirectory" )
			{
				  std::string::size_type last_pos = filename.find_last_of("//");
				  //find first separator
				  i->second = filename.substr(0, last_pos);
			}
			else
			{
				const char *value = it->second;
				i->second = irclean(it->second);
			}
		}
	 }
}

const std::string DicomImageReader::GetStringValueFromTag(const gdcm::DataElement& de)
{
  static std::string buffer;
  buffer = "";  // cleanup previous call


    const gdcm::ByteValue *bv = de.GetByteValue();
    if( bv ) // Can be Type 2
      {
      buffer = std::string( bv->GetPointer(), bv->GetLength() );
      // Will be padded with at least one \0
      }

  // Since return is a const char* the very first \0 will be considered
  return buffer.c_str();
}
  //=====================================================================
  
} // namespace creaImageIO

