/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#include <creaImageIODicomScanner.h>

#include <boost/filesystem.hpp>
#include "boost/algorithm/string.hpp"
#include "boost/filesystem/path.hpp"

#include <fstream>
#if defined(_WIN32)
#pragma warning(disable: 4996)
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif
namespace creaImageIO
{

  //=====================================================================
  DicomImageScanner::DicomImageScanner()
  {
	  mReader =  vtkGDCMImageReader::New();
	mscan.ClearTags();
	b_loaded = false;
  };
  //=====================================================================
  
  //=====================================================================
  DicomImageScanner::~DicomImageScanner()
  {
	  mReader->Delete();
  }
  //=====================================================================

  //=====================================================================  
  bool DicomImageScanner::addDirectory(std::string& filename,  std::map<std::string,std::string>& attr)
  { 
	  	if(!b_loaded)
	{
		mscan.ClearTags();
		std::map<std::string,std::string>::iterator i;
		int j= 0;
		for (i=attr.begin();i!=attr.end();++i, j++)
		  {
			if ( i->first == "D0004_1500" ||  i->first == "FullFileName" || i->first == "FullFileDirectory" )
			{
			
			}
			else
			{
			uint16_t el;
			uint16_t gr;
			
			tree::AttributeDescriptor::GetDicomGroupElementFromKey(i->first,gr,el);
			mscan.AddTag(gdcm::Tag(gr,el) );
			
			}
		}
		b_loaded = true;
	}
	  gdcm::Directory d;
	    
	  boost::algorithm::replace_all(filename,"\\", "/");
	  d.Load(filename.c_str(),true);
	  mscan.Scan(d.GetFilenames());
	  
      return  true;
  	 
  }
  //=====================================================================

  //=====================================================================
  vtkImageData* DicomImageScanner::ReadImage(const std::string& filename)
  {
    vtkImageData* im = 0;
    try
      {
	mReader->SetFileName(filename.c_str());
	mReader->Update();
	im = vtkImageData::New();
	im->ShallowCopy(mReader->GetOutput());
      }
    catch (...)
      {
	if (im!=0) im->Delete();
	  im = 0;
      }
    return im;
  }


  //=====================================================================
  
  //========================================================================
  std::string DicomImageScanner::irclean(const std::string& str)
  {
	  if(str.size() > 0)
	  {
		if (str == "GDCM::Unfound") 
		  {
		return "";
		  }
		if (str[str.size()-1]==' ')
		  {
		return irclean(str.substr(0,str.size()-1));
		  }
		if (str[str.size()-1]==0)
		  {
		return irclean(str.substr(0,str.size()-1));
		  }
	  }
    
    return str;
  }
  //========================================================================
 
  //=====================================================================

void DicomImageScanner::ReadAttributes(const std::string& filename, 
		      std::map<std::string,std::string>& attr)
  {
	  std::string name = "E:\\data-images\\dicoms\\CD1\\DICOM\\09112417\\37390000/31582235";

	 bool b = mscan.IsKey(filename.c_str());
    if( b )      {
		  const gdcm::Scanner::TagToValue &mapping = mscan.GetMapping(filename.c_str());
		  gdcm::Scanner::TagToValue::const_iterator it = mapping.begin();

		  std::map<std::string, std::string>::iterator i;
		  
		  for (;it != mapping.end(); ++it)
		  {		 char key[12] ;
				  sprintf(key,"D%04x_%04x", it->first.GetGroup(), it->first.GetElement());
				  attr[key] = irclean(it->second);
		  }
		  
		  
		 /* 
		  
		  
		  for (i=attr.begin();i!=attr.end();++i, j++)
		{*/
			if ( attr.find("D0004_1500") != attr.end())
			{
				boost::filesystem::path full_path(filename);
				std::string f = full_path.leaf().string();
				attr["D0004_1500"] = f;
			}
			if ( attr.find("FullFileName")!= attr.end())
			{
				attr["FullFileName"] = filename;
			}
			if ( attr.find("FullFileDirectory" )!= attr.end())
			{
				  std::string::size_type last_pos = filename.find_last_of("//");
				  //find first separator
				  attr["FullFileDirectory" ] = filename.substr(0, last_pos);
			}
		//	else
		//	{

		//		uint16_t el;
		//		uint16_t gr;

		//		tree::AttributeDescriptor::GetDicomGroupElementFromKey(i->first,gr,el);

		//	mscan.AddTag(gdcm::Tag(gr,el) );

		//	//	const char *value = it->second;
		//		i->second = irclean(it->second);
		//		++it;
		//	}
		//}
	}
}
















  const std::string DicomImageScanner::GetStringValueFromTag(const gdcm::DataElement& de)
{
  static std::string buffer;
  buffer = "";  // cleanup previous call


    const gdcm::ByteValue *bv = de.GetByteValue();
    if( bv ) // Can be Type 2
      {
      buffer = std::string( bv->GetPointer(), bv->GetLength() );
      // Will be padded with at least one \0
      }


  // Since return is a const char* the very first \0 will be considered
  return buffer.c_str();
}
  //=====================================================================
  
} // namespace creaImageIO

