/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef __creaImageIODicomScanner_h_INCLUDED__
#define __creaImageIODicomScanner_h_INCLUDED__

#include "creaImageIOTree.h"

#if defined(USE_GDCM2)
#include <gdcmReader.h>
#include <vtkGDCMImageReader.h>
#include <gdcmScanner.h>
#include <vtkStringArray.h>
#include <gdcmDirectory.h>
#endif

class vtkGDCMImageReader;

namespace creaImageIO
{


  /**
   * \ingroup IO
   */
  
  //=====================================================================
  /// Concrete image reader for DICOM images 
  class DicomImageScanner 
  {
  public:
    DicomImageScanner();
    virtual ~DicomImageScanner();

	/// Add file extensions read by the reader
    bool addDirectory(std::string& filename,   std::map<std::string,std::string>& attr);

	/// return for a file a 2D VTkImage
    virtual vtkImageData* ReadImage(const std::string& filename);
	/// Read the attributes for a file
    virtual void ReadAttributes(const std::string& filename, 
				tree::AttributeMapType& attr);
	void ReadAttributes2(const std::string& filename, 
				tree::AttributeMapType& attr);

	 std::string irclean(const std::string& str);
  private:
	  const std::string GetStringValueFromTag( const gdcm::DataElement& ds);
	  vtkGDCMImageReader *mReader;
	  gdcm::Scanner mscan;
	  bool b_loaded;

  };
  //=====================================================================



} // namespace creaImageIO



#endif // #ifndef __creaImageIODicomScanner_h_INCLUDED__
