/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOGimmickReaderDialog.h>
#include <creaImageIOWxGimmickReaderDialog.h>

namespace creaImageIO
{

  bool GimmickReaderDialog(std::vector<vtkImageData*>& images,
			   const std::string i_namedescp , 
			   const std::string i_namedb ,
			   const std::string& title,
			   int posx, 
			   int posy,
			   int sizex,
			   int sizey,
			   int image_min_type,
			   int image_max_type,
			   int image_out_dim,
			   int nb_threads)
  {

    
    creaImageIO::WxGimmickReaderDialog w(0,
					 -1,
					 i_namedescp,
					 i_namedb,
					 crea::std2wx(title),
					 wxPoint(posx,posy),
					 wxSize(sizex,sizey),
					 image_min_type,
					 image_max_type,
					 nb_threads);
    w.ShowModal();
    
    if (w.GetReturnCode() == wxID_OK)
      {
	w.GetSelectedImages(images,image_out_dim);
	return true;
      }
    else if (w.GetReturnCode() == wxID_CANCEL)
      {
	return false;
      }
    else 
      {
	std::cout << "!! ERROR : GimmickReaderDialog : dialog ended without return code !"
		  <<std::endl;
	return false;
      }
  
  
  }

}
