/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOGimmickReaderDialog_h_INCLUDED__
#define __creaImageIOGimmickReaderDialog_h_INCLUDED__

#include "creaImageIOSystem.h"
#include <vtkImageData.h>
#include <vector>

 extern "C"								
 {			
	CREAIMAGEIO_EXPORT vtkImageData* getImageDataDialog();
 }

namespace creaImageIO
{
  /**
   * \ingroup GUI
   * \brief Pops up a WxGimmickReaderDialog 
   * returns true if the user clicked 'Ok', false if 'Cancel'
   *  and fills the vector of images
   */
  bool CREAIMAGEIO_EXPORT GimmickReaderDialog
  (std::vector<vtkImageData*>& images,
   const std::string i_namedescp , 
   const std::string i_namedb = "Local Database",
   const std::string& title = "Select images",
   int posx = 0, int posy = 0,
   int sizex = 1200, int sizey = 800,
   int image_min_type = 2,
   int image_max_type = 3,
   int image_out_dim = 2,
   int nb_threads = 1);
  
}

#endif
