/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOListener.h>
#include <creaImageIOSystem.h>
#include "boost/filesystem.hpp"
#include <boost/filesystem/operations.hpp>
#include <boost/utility.hpp>

namespace fs = boost::filesystem;
using boost::filesystem::path;

using namespace crea;

namespace creaImageIO
{
  //=====================================================================
  // CTor
  Listener::Listener()
  {

	boost::mutex::scoped_lock lock(mMutex);
    GimmickDebugMessage(6,"Listener::Listener"
			<<std::endl);
	mDrive="E:";
	mMounted=false;
	mAddFiles=false;
	mRemoveFiles=true;

  }
  //=====================================================================

  //=====================================================================
  /// Destructor
  Listener::~Listener()
  {
    boost::mutex::scoped_lock lock(mMutex);
    GimmickDebugMessage(6,"Listener::~Listener"
			<<std::endl);
  }
  //=====================================================================

  void*  Listener::Entry()
  {	  
    GimmickDebugMessage(6,"Listener::Entry()"<<std::endl);
	while(!TestDestroy())
	  { 
		try  
		{
			fs::exists( mDrive );
			if(!mMounted && mAddFiles)
			{
				mMounted=true;
				SendSignal(mMounted);		
			}
			else if(!mMounted)
			{
				mMounted=true;
			}
			
		}
		catch (...)
		{
			if(mMounted && mRemoveFiles)
			{
			  mMounted=false;
			  SendSignal(mMounted);
			}
			else if(mMounted)
			{
				mMounted=false;
			}
		}

		clock_t endwait;
		endwait = clock () + 0.001 * CLOCKS_PER_SEC ;
		while (clock() < endwait ) {}
			
      }
    return 0;
  }

  //=====================================================================

  //=====================================================================
  void Listener::OnExit()
  {
    GimmickDebugMessage(6,"Listener::OnExit() "<<std::endl);
  }

   //====================================================================
  void Listener::ConnectObserver(MountingCallbackType callback)
  {
    mMountingSignal.connect(callback);
  }

   //======================================================================
  void Listener::SendSignal(bool mount)
  {
	  mMountingSignal(mount);
  }



 
} // EO namespace creaImageIO

