/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOOutputModel.h>
#include <boost/filesystem.hpp>
#include "boost/algorithm/string.hpp"

#if defined(USE_GDCM)
#include <gdcmGlobal.h>
#include <gdcmFile.h>
#include <gdcmSerieHelper.h>
#include <gdcmFile.h>
#endif

#if defined(USE_GDCM2)
#include <gdcmDict.h>
#include <gdcmDicts.h>
#include <gdcmGlobal.h>
#endif

#if defined(USE_XERCES)
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
using namespace xercesc;
#endif


namespace creaImageIO
{

	OutputModel::~OutputModel()
	{
	}

#if defined(USE_GDCM)
	 double OutputModel::orderFilesWithZspacing(std::vector<std::string> &im)
	{
		double spacing=1;
		typedef std::vector<GDCM_NAME_SPACE::File* > FileList;
		FileList fileVector;
		//GDCM_NAME_SPACE::File *f = GDCM_NAME_SPACE::File::New();
		GDCM_NAME_SPACE::SerieHelper *sh = GDCM_NAME_SPACE::SerieHelper::New();
		std::vector<std::string> lstAux;
		std::vector<std::string>::iterator it;
		for (it=im.begin(); it!=im.end(); ++it)
		{
			///\TODO liberer les GDCM_NAME_SPACE::File a la fin!  // JPR
			GDCM_NAME_SPACE::File *f = GDCM_NAME_SPACE::File::New();
			f->SetFileName(*it);
			f->Load();
			if (f->IsReadable())
			{
				fileVector.push_back(f);
			} else {
				lstAux.push_back(*it);
			}
		} // for

		if ((fileVector.size()>1) && (sh->IsCoherent( &fileVector )))
		{
				sh->OrderFileList(&fileVector);
				spacing= sh->GetZSpacing();
				im.clear();
				int i;
				for (i=0; i<fileVector.size(); i++)
				{
					im.push_back( (fileVector[i])->GetFileName() );
				}
				for (i=0; i<lstAux.size(); i++)
				{
					im.push_back( lstAux[i] );
				}
		}else {
			std::sort( im.begin(), im.end() );
		}
		
	   return spacing;
	}

#endif

#if defined(USE_GDCM2)
	// TO DO
	double OutputModel::orderFilesWithZspacing(std::vector<std::string> &im)
	{
		return 1;
	}
#endif

#if defined(USE_XERCES)

	OutputModel::OutputModel(OutputModelParser *i_outparser) : m_outparser(i_outparser)
	{
		// Init
		b_db = false;
	}

	//OutputModel::setOutputModel(std::vector< std::map<std::string, std::string>> i_outputs)
	//{
	//	std::vector< std::map<std::string, std::string>>::iterator it = i_outputs.begin();
	//	for(; it != i_outputs.end(); it++)
	//	{
	//		checkModel((*it));
	//	}
	//}

	 bool OutputModel::checkModel(std::map<std::string, std::string> i_model, const std::string i_val)
	{
		bool bres = false;
		if( i_model.find(i_val) != i_model.end() )
		{
			bres = true;
		}

		return bres;
	}

	OutputModel::~OutputModel()
	{
	}
	void OutputModel::setDB(const std::string i_db, const std::string i_table)
	{
		b_db = true;
		m_db = i_db;
		m_table = i_table;
	}

	const std::string OutputModel::getTag()
	{
		char key[12];
		if (!m_tag.empty())
		{
			return m_tag;
		}
		else
		{
#if defined(USE_GDCM)
		sprintf(key,"D%04x_%04x", m_tag1.GetGroup(), m_tag1.GetElement());
#endif
#if defined(USE_GDCM2)
		sprintf(key,"D%04x_%04x", m_tag2.GetGroup(), m_tag2.GetElement());
#endif
		return key;
		}
	}
/*	 void OutputModel::sort(const std::vector<std::string> i_filenames, std::vector<std::string> &o_sort)
	{
		std::vector<int> values;
		if(bDicom)
		{
			if(b_db)
			{
				getDBValues<int>(i_filenames, values);
			}
			else
			{
				getValues<int>(i_filenames, values);
			}
		}
		else
		{
			for(int i = 0; i <i_filenames.size(); i++)
				values.push_back(i);
		}

		for(int index = tag_begin; index <= tag_end; index += tag_step)
		{
			std::vector<int>::iterator it_val = values.begin();
			std::vector<std::string>::const_iterator it = i_filenames.begin();
			for(;it != i_filenames.end(); it_val++, it++)
			{
				if((*it_val) == index)
				{
					o_sort.push_back((*it));
					break;
				}
			}
		}
		if(m_model != NULL)
			m_model->sort(i_filenames, o_sort);
	}*/
	template<typename T>
	void OutputModel::getDBValues(const std::vector<std::string> i_filenames, const std::string i_stag, std::map<std::string , T> &o_val)
	{
	}


	 //template<typename T>
	 //T OutputModel::getTypeTag()
	 //{
		// GDCM_NAME_SPACE::DictEntry* entry =	GDCM_NAME_SPACE::Global::GetDicts()->GetDefaultPubDict()->GetEntry(GetGroup(),GetElement());
		// entry->GetVR().GetVRType( entry->GetVR());
		// 
	 //}

	template<typename T>
	void OutputModel::getValues(const std::vector<std::string> i_filenames,const std::string i_tag, std::map< std::string, T> &o_val)
	 {
#if defined(USE_GDCM)
		  getReadValues(i_filenames, o_val);
#endif
#if defined(USE_GDCM2)
		  getScanValues(i_filenames, i_tag,o_val);
#endif
	 }

#if defined(USE_GDCM2)
	// TO DO if some file don't provide this value, we are lost so return a map!
	template<typename T>
	void OutputModel::getScanValues(const std::vector<std :: string> i_filenames, const std::string i_stag, std::map<std::string,T> &o_val)
	{
		uint16_t gr, el;
		sscanf(i_stag.c_str(),"D%04hx_%04hx ",&gr,&el); 
		gdcm::Tag tag(gr, el);
		if (!tag.IsIllegal())
		{
			std::vector<std :: string> names(i_filenames);
			gdcm::Scanner scan;
			scan.ClearTags();
			scan.AddTag(tag);
			
			std::vector<std :: string>::iterator it = names.begin();
			for(;it != names.end(); it++)
				boost::algorithm::replace_all((*it),"\\", "/");
			scan.Scan(i_filenames);
//			const gdcm::Scanner::TagToValue &mapping = 
			std::vector<std::string>::const_iterator it_file = i_filenames.begin();
			for(; it_file != i_filenames.end(); it++)
			{
				if(	scan.GetMapping((*it_file).c_str()).begin() != scan.GetMapping((*it_file).c_str()).end())
				{
					o_val[(*it)] = scan.GetMapping((*it_file).c_str()).begin()->second;
				}
				else
				{
					o_val[(*it)] = "";
				}
			}
		} 
	}

	//const gdcm::VR::VRType OutputModel::getType(const std::string i_tag)
	//{
	//	uint16_t gr, el;
	//	sscanf(itag.c_str(),"D%04hx_%04hx ",&gr,&el); 
	//	const gdcm::Global& g = gdcm::Global::GetInstance(); // sum of all knowledge !
	//	const gdcm::Dicts &dicts = g.GetDicts();
	//	const gdcm::Dict &dict = dicts.GetPublicDict(); // Part 6
	//    gdcm::DictEntry dictentry =  dict.GetDictEntry(gdcm::Tag(gr, el));
	//   return dictentry.GetVR();
	//}
#endif


#if defined(USE_GDCM)
	double OutputModel::orderFiles(std::vector<std::string> im, std::vector<std::string> &out)
{
	double spacing = 1;
	std::vector<boost::shared_ptr<GDCM_NAME_SPACE::File> > fileVector;
	std::vector<std::string> lstAux;
	GDCM_NAME_SPACE::SerieHelper *sh = GDCM_NAME_SPACE::SerieHelper::New();
	std::vector<std::string>::iterator it = im.begin();
	for (; it!=im.end(); ++it)
	{
		GDCM_NAME_SPACE::File *f = GDCM_NAME_SPACE::File::New();
		f->SetFileName(*it);
		f->Load();
		if (f->IsReadable())
		{
			fileVector.push_back(f);
		} 
		else
		{
			lstAux.push_back((*it));
		}
	} 
	if ((fileVector.size()>1) && (sh->IsCoherent( &fileVector )))
	{
			sh->OrderFileList(&fileVector);
			spacing= sh->GetZSpacing();
			out.clear();
			int i;
			for (i=0; i<fileVector.size(); i++)
			{
				out.push_back( (fileVector[i])->GetFileName() );
			}
			for (i=0; i<lstAux.size(); i++)
			{
				out.push_back( lstAux[i] );
			}
	}
	else
	{
		std::sort( im.begin(), im.end() );
	}
     return spacing;
	}
#endif 


	void OutputModel::sort(const std::vector<std::string> i_filenames, std::vector<std::string> &o_sort, int level)
	{
#if defined(USE_XERCES)
		int tags[3];
			tags[0] = 0;

		int tag_end = i_filenames.size();
		int tag_step = 1;
		std::map<std::string, std::string> model = m_outparser->getLevel(level);
		std::map<std::string, std::string> values;
		
		if( checkModel(model, OUTPUTMODEL_TAG(3)) && !b_db)
		{
#if defined (USE_GDCM2)
	
			//OutputSort< getType(model[OUTPUTMODEL_TAG(3)] > osort;
			
			getValues<std::string>(i_filenames, model[OUTPUTMODEL_TAG(3)], values);
#endif
		}
		else
		{
			OutputSort<std::string> osort;
			for(int i = 0; i < 3; i++)
			{
				if ( checkModel(model, OUTPUTMODEL_TAG(i)))
				{	
					osort.setTag(model[OUTPUTMODEL_TAG(i)],OUTPUTMODEL_TAG(i));
				}
			}

			if(b_db)
			{
				getDBValues<std::string>(i_filenames,model[OUTPUTMODEL_TAG(3)], values);
			}
			else
			{
				for(int i = 0; i <i_filenames.size(); i++)
					values[i_filenames[i]] = i;
				osort.sort(values,o_sort);
			}
		}




		for(int i = 1; i < 4; i++)
		{
			if ( checkModel(model, OUTPUTMODEL_TAG(i)))
			{	
				sscanf(model[OUTPUTMODEL_TAG(i)].c_str(), "%d", tags[i]);
			}
		}
		
		if( checkModel(model, OUTPUTMODEL_TAG(3)) )
		{
			if(b_db)
			{
				getDBValues<std::string>(i_filenames,model[OUTPUTMODEL_TAG(3)], values);
			}
			else
			{
				getValues<std::string>(i_filenames, model[OUTPUTMODEL_TAG(3)], values);
			}
		}
		else
		{
			for(int i = 0; i <i_filenames.size(); i++)
				values[i_filenames[i]] = i;
		}

		for(int index = tag_begin; index <= tag_end; index += tag_step)
		{
			std::map<std::string, std::string>::iterator it_val = values.begin();
			for(;it_val != values.end(); it_val++)
			{
				if(it_val->second.c_str() )// == index)
				{
					o_sort.push_back(it_val->first.c_str());
					break;
				}
			}
		}
		if(checkModel(model, OUTPUTMODEL_TAG(4)))
		{
			int lv;
			sscanf(model[OUTPUTMODEL_TAG(4)].c_str(), "%d", lv);
			sort(i_filenames,o_sort,lv);
		}
#endif
	}
#endif

}
