/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef __creaImageIOoutputModel_h_INCLUDED__
#define __creaImageIOoutputModel_h_INCLUDED__
#if defined (USE_XERCES)
#include <creaImageIOOutputModelParser.h>
#endif
#if defined(USE_GDCM2)
#include <gdcmScanner.h>
#endif

#include <vector>
#include <string>

#define OUTPUTMODEL_TAG_i	""
#define OUTPUTMODEL_TAG_0	"TAG_BEGIN"
#define OUTPUTMODEL_TAG_1	"TAG_END"
#define OUTPUTMODEL_TAG_2	"TAG_STEP"
#define OUTPUTMODEL_TAG_3	"DICOM_TAG"
#define OUTPUTMODEL_TAG_4	"ANCHOR"
#define OUTPUTMODEL_TAG(i)	OUTPUTMODEL_TAG_ ## i

namespace creaImageIO
{

	class  OutputModel 
	{
	public:
		OutputModel(){}
		virtual ~OutputModel();
		double orderFilesWithZspacing(std::vector<std::string> &im);

#if defined(USE_XERCES)
		OutputModel(OutputModelParser *i_outparser);
	
		// Test if we need to check the "dicom" tag if it exists on database
		void setDB(const std::string i_db, const std::string i_table);

		const std::string getTag();

	private:

		OutputModelParser *m_outparser;

		// dimensions of output
		int dim;

		// index to indicate if one model is available to perform sorting
		bool bmodel;
		
		// index to indicate of a "DICOM" tag is selected to perform sorting
		// not necessary a dicom tag
		// for the moment only Gimmick Tag format accepted but should be GDCM2 format or GDCM1.3 too
		bool bDicom;

		// database name
		std::string m_dbname;
		
		std::string m_tag;
#if defined(USE_GDCM)
		//m_tag1;
		template<typename T>
		//void getReadValues(const std::vector<std :: string> i_filenames, std::vector<T> &o_val);
		double orderFiles(std::vector<std::string> im, std::vector<std::string> &out);

#endif
#if defined(USE_GDCM2)
		gdcm::Tag	m_tag2;

		template<typename T>
		void getScanValues(const std::vector<std :: string> i_filenames, const std::string i_stag, std::map<std::string,T> &o_val);
	
		/*template<typename T>
		T getTypeTag();*/
#endif

		// the initial value to start sorting
		int tag_begin;

		// the final value to end sorting
		int tag_end;

		// step for the values
		int tag_step;

		// if the sorting is not the same for the set of data, we include another OutputModel
		// ex : if we want a step = 20 for the 100 first values, next a step = 10 for the next 100 and step = 1 for the lastest value
		OutputModel *m_model;

		// indicates if the sorting tag is present in database or not
		bool b_db;

		std::string m_db;

		std::string m_table;

		template<typename T>
		void getValues(const std::vector<std::string> i_filenames,const std::string i_tag, std::map< std::string, T> &o_val);
		template<typename T>
		void getDBValues(const std::vector<std::string> i_filenames, const std::string i_stag, std::map<std::string,T> &o_val);

		void sort(const std::vector<std::string> i_filenames, std::vector<std::string> &o_sort, int level);

		bool checkModel(std::map<std::string, std::string> i_model, const std::string i_val);
#endif
	};
	
/*
	 template <class T>
	 class OutputSort
	 {
	 public :
		 std::map <std::string, T> values;
		 std::map<std::string, T> tags;

		 void setTag(T i_tag, const std::string name)
		 {
			 tags[name] = i_tag;
		 }

		 void sort (const std::map<std::string, T> i_values, std::vector<std::string> &o_sort)
		 {
		        std::map<std::string, T>::const_iterator it_val; 
			for(T index = tags[OUTPUTMODEL_TAG(0)]; index <= tags[OUTPUTMODEL_TAG(1)]; index += tags[OUTPUTMODEL_TAG(2)])
			{
				//std::map<std::string, T>::const_iterator it_val; 
				for(it_val = i_values.begin();it_val != i_values.end(); it_val++)
				{
					if(it_val->second.c_str()  == index)
					{
						o_sort.push_back(it_val->first.c_str());
						break;
					}
				}
			 }
		 }
	 };
*/
	
} // namespace creaImageIO
#endif //__creaImageIOoutputModel_h_INCLUDED__
