/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/fstream.hpp"

#include "creaImageIOSimpleView.h"
#include "creaImageIOUnMosaicVtkImageData.h"

namespace creaImageIO
{
	bool SimpleView::readFile(	std::vector<std::string> i_filenames,   								// in information names
										std::vector<std::string> i_attr,								// in information attributes names
										std::vector<std::map <std::string , std::string> > &i_imgAttr,	// out information attributes names-values
										std::vector<vtkImageData *> &i_img)     						// out information vtkImageData
	{

		  //Mosaic Attribute for Simens		
			i_attr.push_back("D0019_100a");  // Number of images in mosaic (Simens)
			i_attr.push_back("D0018_0088");  // Spacing Between Slices
		


			creaImageIOUnMosaicVtkImageData Mosaic;
			vtkImageData* tmpImg1;
			vtkImageData* tmpImg2;
			int numberOfImagesInMosaic;
			double spc[3];
			double spcZ;

			bool bresult, bfinal = true;
			ImageReader *mReader = new ImageReader();
			std::vector<std::string>::iterator it = i_filenames.begin();
			for (; it != i_filenames.end(); it++)
			{
				bresult = mReader->CanRead((*it).c_str());
				if(bresult)
				{
					std::map <std::string , std::string> mapAttr;
					mReader->getAttributes( (*it).c_str() , mapAttr, i_attr ); //  filename, outMapAttr-NameValue, inVectAttributeName
					i_imgAttr.push_back( mapAttr );

//EED borrame
//					i_img.push_back( mReader->ReadImage( (*it).c_str() ) );


					// EED 18 octt 2014
					std::map <std::string , std::string>::iterator itMapAttr;
					std::string numberOfImagesInMosaicStr="";
					std::string spaceBetweenSliceStr="";

					itMapAttr = mapAttr.find("D0019_100a");
					if ( itMapAttr!=mapAttr.end() ) numberOfImagesInMosaicStr = itMapAttr->second;

//					std::string numberOfImagesInMosaicStr = mapAttr.find("D0019_100a")->second;
					itMapAttr = mapAttr.find("D0018_0088");
					if ( itMapAttr!=mapAttr.end() ) spaceBetweenSliceStr = itMapAttr->second;

//					std::string spaceBetweenSliceStr = mapAttr.find("D0018_0088")->second;
					if (numberOfImagesInMosaicStr=="")
					{
						i_img.push_back( mReader->ReadImage( (*it).c_str() ) );
					} else {
						numberOfImagesInMosaic = atoi(numberOfImagesInMosaicStr.c_str());
						spcZ = atoi(spaceBetweenSliceStr.c_str());
						tmpImg1 = mReader->ReadImage( (*it).c_str() ) ;
						tmpImg1->GetSpacing( spc );	
						tmpImg2 = Mosaic.unMosaic( tmpImg1 , numberOfImagesInMosaic );
						tmpImg2->SetSpacing( spc[0], spc[1], spcZ );	
						i_img.push_back( tmpImg2 );
					}// elemet

				} else {
					printf("ERROR. Impossible to read file %s\n", (*it).c_str() );
					bfinal = false;
				} // if
			} // for
			delete mReader;

			return bfinal;	
	}


	bool SimpleView::readDirectory(	const std::string i_pathname, 											// in information names
												std::vector<std::string> i_attr,											// in information attributes names
												std::vector<std::map <std::string , std::string> > &i_imgAttr,	// out information attributes names-values
												std::vector<vtkImageData *> &i_imgs)									// out information vtkImageData
	{
			bool bresult = true;
			ImageReader *mReader = new ImageReader();
                        std::vector<std::string> names;
			bresult = boost::filesystem::exists( i_pathname );
			if (bresult)
			{
				boost::filesystem::directory_iterator itr(i_pathname);
				boost::filesystem::directory_iterator end_itr; 
				for(;itr != end_itr; ++itr)
				{
					if (!boost::filesystem::is_directory(itr->status()))
					{
						if( mReader->CanRead(itr->path().string()) )
						{
							names.push_back(itr->path().string()); 
						}
					}
				}
				std::sort (names.begin(), names.end()); // make sure names are in lexicographical order
				int lgr = (int)names.size();
				
				for(int i=0; i<lgr; i++)
				{
               std::cout << names[i] << std::endl;

					std::map <std::string , std::string> mapAttr;
					mReader->getAttributes( names[i] , mapAttr, i_attr ); //  filename, outMapAttr-NameValue, inVectAttributeName
					i_imgAttr.push_back( mapAttr );

					//UnMosaic step..

				   i_imgs.push_back( mReader->ReadImage(names[i]) );  
				}			
			}
			return bresult;
	}
}
