/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOSystem.h>
#include <creaImageIOSynchronizer.h>
#include "boost/filesystem.hpp"

namespace fs = boost::filesystem;

namespace creaImageIO
{

  //==============================================================
	Synchronizer::Synchronizer(TreeHandler * th)
    : mHandler(th)
  {    
   
  }
  //==============================================================
 
  //==============================================================
	Synchronizer::~Synchronizer()
  {    
   
  }
  //==============================================================

  //==============================================================
  std::string Synchronizer::Synchronize(bool update)
  {
	  GimmickMessage(1,"Synchronizing "<<std::endl);
	  int id=1;
	  std::stringstream mess;
	  std::string file;
	  mHandler->GetAttribute("Image","","","FullFileName",file);
	  size_t ini=0;
	  size_t fin=0;
	  while(fin<file.size()-1)
	  {
	   fin=file.find('#',ini);
	   SynchronizeFile(update,file.substr(ini,fin-ini),mess);
	   ini=fin+1;
	  }
	  if(mess.str()=="")
	  {
		  mess<<"Database up to date"<<std::endl;
	  }
	  GimmickMessage(1,mess.str());
	  return mess.str();
  }
  //==============================================================

  //==============================================================
  void Synchronizer::SynchronizeFile(bool update, std::string file, std::stringstream& mess)
  {
	if(!FileExists(file))
	{
		if(update)
		{
			mHandler->DeleteTuple("Image","FullFileName",file);
			mess<<file<<" has been removed from the DB"<<std::endl;
		}
		else
		{
			mess<<file<<" State: Non existant"<<std::endl;
		}
	}
	else 
	{
		AttributesMatch(update,file,mess);
	} 
  }
  //==============================================================

  //==============================================================
  bool Synchronizer::FileExists(std::string file)
  {
	  GimmickDebugMessage(4,"Verifying if file "<<file<<" exists"<<std::endl);
	  bool exists=true;
	  if ( !fs::exists( file ) )
	  {
		  exists=false;
	  }
	  return exists;
  }
  //==============================================================

  //==============================================================
  void Synchronizer::AttributesMatch(bool update, std::string file, std::stringstream& mess)
  {
	  std::map< std::string, std::string>  attr;
	  mHandler->GetTree().GetDescriptor().BuildAttributeMap(attr);
      mReader.ReadAttributes(file,attr);
	  tree::LevelDescriptor::AttributeDescriptorListType adl= mHandler->GetTree().GetAttributeDescriptorList(mHandler->GetTree().GetNumberOfLevels()-1);	
	  tree::LevelDescriptor::AttributeDescriptorListType::const_iterator a;
	  for (a = adl.begin();a!=adl.end();++a)
	  {
	   std::string databaseVal;
	   mHandler->GetAttribute("Image","FullFileName",file,a->GetKey(),databaseVal);
	   std::string fileVal=attr.find(a->GetKey())->second;
	   if ( a->GetFlags()==0 && databaseVal.compare(fileVal)!=0 ) 
	    {
		  if(update)
			{
				mHandler->SetAttribute("Image",a->GetKey(),fileVal,"FullFileName", file);
				mess<<file<<" has been updated in the DB"<<std::endl;
			}
			else
			{
				mess<<file<<" State: Attributes differ"<<std::endl;
			}
	    }
	  }
  }
  //==============================================================

}