/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#include <creaImageIOTreeLevelDescriptor.h>
#include <creaImageIOSystem.h>


namespace creaImageIO
{
  namespace tree
  {
    /// Adds the AttributeDescriptor to the list
    void LevelDescriptor::Add(const AttributeDescriptor& a)
    {
      GimmickMessage(5,"Adding Attribute Descriptor '"<<a.GetKey()
		     <<"' to LevelDescriptor"
		     <<std::endl);
      mAttributeDescriptorList.push_back(a);
      if ( a.GetFlags() & AttributeDescriptor::IDENTIFIER )
	{
	  GimmickMessage(6,"Is an IDENTIFIER"<<std::endl);
	  mIdentifierList.push_back(a.GetKey());
	}
      if ( a.GetFlags() & AttributeDescriptor::LABEL )
	{
	  GimmickMessage(6,"Is a LABEL"<<std::endl);
	  mLabelList.push_back(a.GetKey());
	}
    }

	// Copy the descriptor List without ID and PATIENT_ID attributes
	void LevelDescriptor::CopyAttributeDescriptorList() 
      { 
		  mAttributeDescriptorListWID = mAttributeDescriptorList; 
		  for(AttributeDescriptorListType::iterator it = mAttributeDescriptorListWID.begin();
			  it != mAttributeDescriptorListWID.end(); it++)
		  {
			  if((*it).GetKey() == "ID")
			  {
					mAttributeDescriptorListWID.erase(it);
					break;
			  }
		  }

		  for(AttributeDescriptorListType::iterator it = mAttributeDescriptorListWID.begin();
			  it != mAttributeDescriptorListWID.end(); it++)
		  {
			  if((*it).GetKey() == "PARENT_ID")
			  {
					mAttributeDescriptorListWID.erase(it);
					break;
			  }
		  }
	 }

  }
}

