/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOUltrasonixImageReader_h_INCLUDED__
#define __creaImageIOUltrasonixImageReader_h_INCLUDED__

#include <creaImageIOAbstractImageReader.h>
#include <creaImageIOSystem.h>

namespace creaImageIO
{
  /**
   * \ingroup IO
   */
  
  //=====================================================================
  /// Concrete image reader for ultrasonix 'rf' files
  class CREAIMAGEIO_EXPORT UltrasonixImageReader : virtual public AbstractImageReader
  {
  public:
    UltrasonixImageReader();

    virtual ~UltrasonixImageReader();
	/// Add file extensions read by the reader
    virtual void PushBackExtensions(std::vector<std::string>&);
	/// Test if file is read by this reader
    virtual bool CanRead(const std::string& filename);
	/// return for a file a 2D VTkImage
    virtual vtkImageData* ReadImage(const std::string& filename);
	/// Read the attributes for a file
    virtual void ReadAttributes(const std::string& filename, 
				tree::AttributeMapType& attr);

	 virtual void getAttributes(const std::string filename,
		std::map <std::string , std::string> &infos, std::vector<std::string> i_attr);

  };
  //=====================================================================

} // namespace creaImageIO

#endif // #ifndef __creaImageIOUltrasonixImageReader_h_INCLUDED__
