/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sante)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#include "creaImageIOUnMosaicVtkImageData.h"
#include <math.h>


namespace creaImageIO
{

// ------------------------------------------------------------------------
creaImageIOUnMosaicVtkImageData::creaImageIOUnMosaicVtkImageData()
{
}

// ------------------------------------------------------------------------
creaImageIOUnMosaicVtkImageData::~creaImageIOUnMosaicVtkImageData()
{
}

// ------------------------------------------------------------------------
std::vector<vtkImageData*> creaImageIOUnMosaicVtkImageData::unMosaicVectorVtkImageData (std::vector<vtkImageData*> imageInput, std::vector<int> NbImagesInMosaicVector)
{
	std::vector<int> nbImagesInMosaic;

	for(int i = 0; i < NbImagesInMosaicVector.size(); i++)
	{
		nbImagesInMosaic.push_back(NbImagesInMosaicVector[i]);
	}

	if(imageInput.size() != NbImagesInMosaicVector.size())	
	{
		for(int j = NbImagesInMosaicVector.size(); j < imageInput.size(); j++)	
		{	
			nbImagesInMosaic.push_back( NbImagesInMosaicVector[NbImagesInMosaicVector.size()-1] );
		}
	}
	
	if ( nbImagesInMosaic.size()==0 ) 
   {
   		std::cout << "VtkUnMosaicVectorVtkImageData ERROR: The number of Images by mosaic is not set " << std::endl; 
	}

	std::vector<vtkImageData*> imageIn = imageInput;

	std::vector<vtkImageData*> mImageOut;
	for (int i = 0 ; i < (unsigned int)imageIn.size() ; i++) 
	{
			mImageOut.push_back( unMosaic(imageIn[i], nbImagesInMosaic[i]) );
	}

	return mImageOut;	
}


// ------------------------------------------------------------------------
vtkImageData * creaImageIOUnMosaicVtkImageData::unMosaic(vtkImageData *imageIn, int numberOfImagesInMosaic)
{
	int nbImagesPerRow = ceil( sqrt( (double)numberOfImagesInMosaic) );
   int inputdims[3];
   int outputdims[3];
   imageIn->GetDimensions (inputdims);
   unsigned short *input = (unsigned short *)(imageIn->GetScalarPointer());
   imageIn->Update();
     
   unsigned int div = (unsigned int)ceil(sqrt( (double)numberOfImagesInMosaic ) );
   outputdims[0] = inputdims[0] / div;
   outputdims[1] = inputdims[1] / div;
   outputdims[2] = numberOfImagesInMosaic;
 
    vtkImageData *vtkImageOut;
    vtkImageOut = vtkImageData::New();
    vtkImageOut->SetDimensions( outputdims );
    vtkImageOut->SetExtent(0,outputdims[0]-1,0,outputdims[1]-1,0,outputdims[2]-1);
    vtkImageOut->SetWholeExtent(0,outputdims[0]-1,0,outputdims[1]-1,0,outputdims[2]-1);
    vtkImageOut->SetNumberOfScalarComponents(1);
//vtkImageOut->SetSpacing( blabla );
    vtkImageOut->SetScalarType( VTK_UNSIGNED_SHORT );
    vtkImageOut->AllocateScalars();
    vtkImageOut->Update();
    
    unsigned short *output =(unsigned short *)(vtkImageOut->GetScalarPointer());

    unsigned short *dest = output;
    int dimXImageElem = outputdims[0];
    int dimYImageElem = outputdims[1];
    int lgrImage = dimXImageElem*dimYImageElem;
    int debImage;
    int i,j;
    for (i=0; i<numberOfImagesInMosaic; i++)
//      for (i=numberOfImagesInMosaic-1; i>=0; i--)
    {
       debImage=(i/nbImagesPerRow) * lgrImage*nbImagesPerRow + (i%nbImagesPerRow)*dimXImageElem;
       for(j=0; j<dimYImageElem; j++)
//       for(int j=dimYImageElem-1; j>=0; j--)
       {
          memcpy(dest, input+debImage, dimXImageElem*sizeof(unsigned short));
          debImage += dimXImageElem*nbImagesPerRow;
          dest += dimXImageElem;
       }
    }
    return  vtkImageOut;    
}


} // namespace creaImageIO


