/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOVtkImageReader.h>
#include <vtkImageReader2.h>

#include "boost/filesystem/path.hpp"
#if defined(_WIN32)
#pragma warning(disable: 4996)
#endif

namespace creaImageIO{
  //=====================================================================
  VtkImageReader::VtkImageReader(vtkImageReader2* r, 
				       const std::string& name,
				       const std::string& extensions)
    : mReader(r), mExtensions(extensions)
  {
	  
	//EED 21 mars 2012  FLIP probleme  ..PLOP..
	mReader->FileLowerLeftOff();
	  
    if (name.size() == 0) 
      {
		  const char *test =mReader->GetDescriptiveName();
		  //warning: comparison with string literal results in unspecified behaviour
		  //if(test != "")
		  std::string emptyString("");
		  if(test != emptyString)
		  {
			SetName ( "toto");// mReader->GetDescriptiveName());
		  }
      }
    else 
      {
	SetName ( name );
      }

      
  }
  //=====================================================================
  
  //=====================================================================
  VtkImageReader::~VtkImageReader()
  {

    mReader->Delete();
  }
  //=====================================================================

  //=====================================================================
  bool VtkImageReader::CanRead(const std::string& filename)
  { 

    return (mReader->CanReadFile(filename.c_str())!=0);
/*	  if(filename != "")
	  {
		return (mReader->CanReadFile(filename.c_str())!=0);
	  }
	  else
	  {
		  return false;
	  }*/
  }
  //=====================================================================
  void VtkImageReader::getAttributes(const std::string filename,
		std::map <std::string , std::string> &infos, std::vector<std::string> i_attr)
   {
   }
  //=====================================================================
  vtkImageData* VtkImageReader::ReadImage(const std::string& filename)
  {
    vtkImageData* im = 0;
    try
      {
	printf("EED VtkImageReader::ReadImage  Name:%s\n", GetName().c_str() );
	mReader->SetFileName( filename.c_str() );
	mReader->Update();
	im = vtkImageData::New();

	im->ShallowCopy(mReader->GetOutput());


printf("EED ......\n"); 
printf("EED ......\n");
printf("EED VtkImageReader::ReadImage line 108   Missing FlipImage for JPEG, PNG, etc\n");
printf("EED ......\n"); 
printf("EED ......\n"); 
/*
        im=FlipImageY(im);          

	if ( (GetName()=="JPEG") || (GetName()=="PNG") )
	{

		im->Update();
		int inputdims[3];
		im->GetDimensions (inputdims);

                int nbScalComp	= im->GetNumberOfScalarComponents();
		int scalarSize	= im->GetScalarSize();
		int lineSize	= inputdims[0]*scalarSize*nbScalComp;	   
		int planeSize	= inputdims[1]*lineSize;
                int volumeSize  = inputdims[2]*planeSize;
		char *pixelsIn	= (char *)im->GetScalarPointer();
		char *pixelsOut = (char *)mImageOut->GetScalarPointer();
	
		char *lineIn;
		char *lineOut;
		char *debPlanIn;
		char *debPlanOut;
		int i,j,k;

            	for(k=0; k<inputdims[2]; k++)  // iterate  planes
			{  
				debPlanIn	= pixelsIn+k*planeSize;
				debPlanOut	= pixelsOut+k*planeSize;
				for(j=0; j<inputdims[1]; j++)  // iterates  rows
				{ 
					lineIn = debPlanIn+j*lineSize;
					lineOut = debPlanOut+(inputdims[1]-1-j)*lineSize;
					memcpy(lineOut,  lineIn, lineSize);
				}	// for j
			} // for k
	} // FLIP : JPEG PNG
*/
      }
    catch (...)
      {
	if (im!=0) im->Delete();
	im = 0;
      }
    return im;
  }
  //=====================================================================
  
  //=====================================================================
  void SplitExtensionsString ( const std::string& str, 
			       const std::string& delimiters, 
			       std::vector<std::string>& tokens)
  {
    // Skip delimiters at beginning.
    std::string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first delimiter.
    std::string::size_type pos     = str.find_first_of(delimiters, lastPos);
    
    while (std::string::npos != pos || std::string::npos != lastPos)
      {
	// Found a token, add it to the vector.
	// SPECIFIC : REMOVE INITIAL DOT (lastPos + 1)
	tokens.push_back(str.substr(lastPos+1, pos - lastPos));
	// Skip delimiters.  Note the "not_of"
	lastPos = str.find_first_not_of(delimiters, pos);
	// Find next delimiter
	pos = str.find_first_of(delimiters, lastPos);
      }
    
    }
  //=====================================================================
  
  //=====================================================================
  void VtkImageReader::PushBackExtensions(std::vector<std::string>& v)
  {
    std::string ext = mExtensions;
    if (ext.size()==0) ext = mReader->GetFileExtensions ();
    
    SplitExtensionsString(ext," ",v);
  }
  //=====================================================================
 


  //=====================================================================
  void VtkImageReader::ReadAttributes(const std::string& filename, 
				      std::map<std::string,std::string>& attr)
  {

    // Get image dimensions
    // How to get the image info without loading it in vtk ?
    mReader->SetFileName(filename.c_str());
    mReader->Update(); //OpenFile();
    int ext[6];
    mReader->GetDataExtent(ext);
    // Columns
    char cols[128];
    sprintf(cols,"%i",ext[1]-ext[0]);
    // Rows
    char rows[128];
    sprintf(rows,"%i",ext[3]-ext[2]);
    // Planes 
    char planes[128];
    sprintf(planes,"%i",ext[5]-ext[4]);
   
	std::map<std::string,std::string>::iterator i;
    if ( (i = attr.find("FullFileName")) != attr.end())
      {
	i->second = filename;
      }
    if ( (i = attr.find("D0004_1500")) != attr.end())
      {
	boost::filesystem::path full_path(filename);
	std::string f = full_path.leaf().string();
	i->second = f;
      }
    if ( (i = attr.find("D0028_0010")) != attr.end())
      {
	i->second = rows;
      }
    if ( (i = attr.find("D0028_0011")) != attr.end())
      {
	i->second = cols;
      }
    
    if ( (i = attr.find("D0028_0012")) != attr.end())
      {
		i->second = planes;
      }
	  if ( (i = attr.find("FullFileDirectory")) != attr.end())
      {
    	 std::string::size_type last_pos = filename.find_last_of("//");
		 i->second = filename.substr(0, last_pos);
	  }


  }
  //=====================================================================

} // namespace creaImageIO
