/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include "creaImageIOWxAnySimpleDlg.h"

#include "creaImageIOWxGimmickReaderDialog.h"
#include <itkAnalyzeImageIO.h>
#include <itkImageFileReader.h>
#include <itkImageSeriesReader.h>
#include <itkImage.h>
#include <itkImageSeriesWriter.h>
#include <itkGDCMImageIO.h>
#include <itkDICOMSeriesFileNames.h>
#include <itkNumericSeriesFileNames.h>
#include <itkVectorImage.h>
#include <itkMetaImageIO.h>
#include <vtkImageReader2.h>
#include <vtkMetaImageReader.h>
#include <boost/filesystem/path.hpp>
#include <boost/filesystem.hpp>
#include <boost/utility.hpp>
#include <creaVtkBasicSlicer.h>


namespace creaImageIO
{

   ///Ctor
   WxAnySimpleDlg::WxAnySimpleDlg(wxWindow *parent, 
                                  wxString i_title,  
                                  const std::string i_namedescp , 
                                  const std::string i_namedb)
    : wxDialog(parent, -1,_T("DISPLAY IMAGES"), wxDefaultPosition, wxSize(230,150))
   {
        namedescp    = i_namedescp; 
        namedb       = i_namedb;

       if(!i_title.empty())
       {
            this->SetTitle(i_title);  
       }
       // Button to select file(s)
       wxButton *fileBut = new wxButton(this, -1,_T("Select a file to display"), wxPoint(10,7) );
       Connect( fileBut->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxAnySimpleDlg::OnReadFile ); 

       // Button to select directory
       wxButton *directoryBut = new wxButton(this, -1,_T("Select a directory to display"), wxPoint(10,40) );
       Connect( directoryBut->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxAnySimpleDlg::OnReadDirectory ); 

       // button to select creaImageIO
       wxButton *gimmickBut = new wxButton(this, -1,_T("Select Gimmick"), wxPoint(10,70) );
       Connect( gimmickBut->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxAnySimpleDlg::OnReadGimmick ); 

       /// \TODO  Button to select Bruker directory
        m_dicom = false;
        Layout(); 
    }

//////////////////////////////////////////////////////////////////////
//                                                                  //
//////////////////////////////////////////////////////////////////////
     
     void WxAnySimpleDlg::OnReadFile(wxCommandEvent& event)
      {
          int resultShowModal;
          wxFileDialog* fileDlg = new wxFileDialog( 0,  _T("Select file"), _T(""), _T(""), crea::std2wx("*"), wxOPEN |wxFD_MULTIPLE, wxDefaultPosition);
    
          resultShowModal = fileDlg->ShowModal();
          if ( resultShowModal==wxID_OK )
          {
                wxArrayString wxArray;
                fileDlg->GetPaths(wxArray);
                if(wxArray.size() >0)
                {
                    for( int i = 0; i < wxArray.GetCount(); i++)
                    {
                        std::string name = crea::wx2std(wxArray[i]);
                        // FOR THE MOMENT ONLY short 3D et short 4D
                        readImg(name);
                    }
                } 
                else {
                    // TO DO WARNING MESSAGES
                }
          }
          SetReturnCode( resultShowModal );
//         Close();
          EndModal( resultShowModal );
      }
        
     void WxAnySimpleDlg::setExts(std::vector<std::string> i_exts)
     {
         m_exts = i_exts;
     }
 /////////////////////////////////////////////////////////////////////
//                                                                  //
//////////////////////////////////////////////////////////////////////

      void WxAnySimpleDlg::OnReadDirectory(wxCommandEvent &event)
      {
         int resultShowModal;
         bool bvalid = false;
         long style = wxDD_DEFAULT_STYLE | wxDD_DIR_MUST_EXIST;
         wxDirDialog* dirDlg = new wxDirDialog( 0, _T("Select the directory to display"), _T(""), style);
         
         resultShowModal = dirDlg->ShowModal();
         if ( resultShowModal==wxID_OK )
         {  
            std::string path = crea::wx2std(dirDlg->GetPath());
            typedef boost::filesystem::directory_iterator dir_it;
            dir_it itr(path);
            dir_it end_itr;
            /*if (boost::filesystem::exists(path))
            {*/
                for(;itr != end_itr; ++itr)
                {
                       bvalid = m_exts.size() == 0? true : false;
                       std::vector<std::string>::iterator it = m_exts.begin();
					   std::string ext = itr->path().filename().string().substr(itr->path().filename().string().find_last_of("."));
                       for(; it != m_exts.end(); it++)
                       {
                           if(ext == (*it) )
                           {
                               bvalid = true;
                               break;
                           }
                       }
                       if (!boost::filesystem::is_directory(itr->status()) && bvalid)
                       {
                           readImg(itr->path().string().c_str());
                       }
                }
         }
         SetReturnCode( resultShowModal );
//         Close();
         EndModal( resultShowModal );
      }

//////////////////////////////////////////////////////////////////////
//                                                                  //
//////////////////////////////////////////////////////////////////////
            
      void WxAnySimpleDlg::OnReadGimmick(wxCommandEvent &event)
      {
          // Run Gimmick
         WxGimmickReaderDialog dlg(0,-1, 
                   namedescp,
                   namedb, 
                   _T("Select image(s)        - Gimmick! (c) CREATIS-LRMN 2008"),
                   wxDefaultPosition,
                   wxSize(810,750),
                   GIMMICK_2D_IMAGE_SELECTION,
                   GIMMICK_3D_IMAGE_SELECTION,
                   _3D,
                   1);
         dlg.ShowModal();
         if (dlg.GetReturnCode() == wxID_OK)
         {
            std::vector<std::string> out;
            dlg.stopReading();
            dlg.GetSelectedFiles(out);
            if(m_dicom)
            {
                readDicomImg( out);
            }
            else
            {
                std::vector<std::string>::iterator ii = out.begin();
                for (;ii != out.end();ii++)
                {
                    readImg( (*ii).c_str() );
                }
            }
            dlg.OnExit();
         }
         SetReturnCode( dlg.GetReturnCode() );
//         Close();
         EndModal( dlg.GetReturnCode() );
       }


     
    wxString WxAnySimpleDlg::getInfoImage()
    {
        return infoimage;
    }


      // FCY : just to check but not needed, we hardly suppose that we load only same type and dim of images
    const std::type_info & WxAnySimpleDlg::getType(const std::string &i_name)
    {
            typedef itk::ImageIOBase::IOComponentType ScalarPixelType;
            itk::ImageIOBase::Pointer imageIO =  itk::ImageIOFactory::CreateImageIO(i_name.c_str(), itk::ImageIOFactory::ReadMode);
            imageIO->SetFileName(i_name.c_str());
            imageIO->ReadImageInformation();
            return imageIO->GetComponentTypeInfo();//AsString( imageIO->GetComponentType());
     }

     const size_t WxAnySimpleDlg::getNumberOfDimensions(const std::string &i_name)
     {
            typedef itk::ImageIOBase::IOComponentType ScalarPixelType;
            itk::ImageIOBase::Pointer imageIO =  itk::ImageIOFactory::CreateImageIO(i_name.c_str(), itk::ImageIOFactory::ReadMode);
            imageIO->SetFileName(i_name.c_str());
            imageIO->ReadImageInformation();
            return imageIO->GetNumberOfDimensions();
     }

     void WxAnySimpleDlg::readImg(const std::string &i_name)
     {
          size_t dims = getNumberOfDimensions(i_name);
          //const std::type_info  *type= &getType(i_name);
          switch(dims)
          {
           case 3:
               if (getType(i_name) ==  typeid(unsigned char))
               {
                    typedef itk::Image<unsigned char, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
               }
               else if (getType(i_name) ==  typeid(signed char)) 
               {
                    typedef itk::Image<signed char, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
               }
               else if (getType(i_name) ==  typeid(short))
               {
                    typedef itk::Image<short, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
               }
               else if (getType(i_name) ==  typeid(unsigned short)) 
               {
                    typedef itk::Image<unsigned short, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
              }
              else if (getType(i_name) ==  typeid(unsigned int)) 
              {
                    typedef itk::Image<unsigned int, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
              }
              else if (getType(i_name) ==  typeid(signed int)) 
              {
                    typedef itk::Image<signed int, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
              }
              else if (getType(i_name) ==  typeid(unsigned long)) 
              {
                    typedef itk::Image<unsigned long, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
              }
              else if (getType(i_name) ==  typeid(signed long)) 
              {
                    typedef itk::Image<signed long, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
              }
              else if (getType(i_name) ==  typeid(float)) 
              {
                    typedef itk::Image<float, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
              }
              else if (getType(i_name) ==  typeid(double)) 
              {
                    typedef itk::Image<double, 3> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
              }
              else
              {
                  //????FCY, so what the type????
              }
              break;
              //assume that we have only one 4D file
            case 4:
                if (getType(i_name) ==  typeid(unsigned char))
                {
                    typedef itk::Image<unsigned char, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
                }
                else if (getType(i_name) ==  typeid(signed char)) 
                {
                    typedef itk::Image<signed char, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
                }
                else    if (getType(i_name) ==  typeid(unsigned short))
                {
                    typedef itk::Image<unsigned short, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
                }
                else if(getType(i_name) == typeid(short))
                {
                    typedef itk::Image<short, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    try 
                    { 
                        reader->Update(); 
                    } 
                    catch( itk::ExceptionObject & err ) 
                    { 
                        std::cout << "Caught an exception reading" << i_name << ": " << std::endl; 
                        std::cout << err << " " << __FILE__ << " " << __LINE__ << std::endl; 
                        throw err; 
                    } 
                    catch(...) 
                    { 
                        std::cout << "Error while reading image " << i_name << std::endl; 
                        throw; 
                    } 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
                }
                else if (getType(i_name) ==  typeid(unsigned short)) 
                {
                    typedef itk::Image<unsigned short, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
               }
               else if (getType(i_name) ==  typeid(unsigned int)) 
               {
                    typedef itk::Image<unsigned int, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
               }
               else if (getType(i_name) ==  typeid(signed int)) 
               {
                    typedef itk::Image<signed int, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
               }
               else if (getType(i_name) ==  typeid(unsigned long)) 
               {
                    typedef itk::Image<unsigned long, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
               }
               else if (getType(i_name) ==  typeid(signed long)) 
               {
                    typedef itk::Image<signed long, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
               }
               else if (getType(i_name) ==  typeid(float)) 
               {
                    typedef itk::Image<float, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
               }
               else if (getType(i_name) ==  typeid(double)) 
               {
                    typedef itk::Image<double, 4> TImage;
                    typedef itk::ImageFileReader<TImage> ReaderType; 
                    ReaderType::Pointer reader = ReaderType::New(); 
                    reader->SetFileName( i_name ); 
                    reader->Update(); 
                    reader->GetOutput()->Register();
                    m_AnyImages.push_back(reader->GetOutput());
                    split4Din3Dvtk<TImage>(reader->GetOutput());
               }
               else
               {
                  //????FCY, so what the type????
               }
               break;
           }
           
           // Test to know if we have to add new type
           bool btest = false;
           if( m_AnyDims.size() != 0)
           {
               btest = true;
           }
           else
           {
               m_AnyDims.push_back(dims);
               m_AnyType.push_back((std::type_info*)&getType(i_name));  //JPR cast
           }
           if (btest)
           {
               if(m_AnyDims.front() != dims || m_AnyType.front()->before(getType(i_name)))
               {
                   m_AnyDims.push_back(dims);
                   m_AnyType.push_back((std::type_info*)&getType(i_name)); //JPR cast
               }
               else{}
           }
           else  {}
      }

      void WxAnySimpleDlg::readDicomImg(const std::vector<std::string> &i_names)
      {
          typedef itk::Image<short,3> TImage;
          typedef itk::GDCMImageIO GDCMType;
          typedef itk::DICOMSeriesFileNames dicnames;
          GDCMType::Pointer gdcmIO = GDCMType::New(); 
          dicnames::Pointer generator = dicnames::New();


            typedef itk::ImageSeriesReader<TImage> ReaderType; 
            ReaderType::Pointer reader = ReaderType::New(); 
            reader->SetImageIO(gdcmIO);
            reader->SetFileNames(i_names);
        //    reader->SetFileName( i_name ); 
            try 
            { 
                reader->Update(); 
            } 
            catch( itk::ExceptionObject & err ) 
            { 
            //    std::cout << "Caught an exception reading" << i_name << ": " << std::endl; 
                std::cout << err << " " << __FILE__ << " " << __LINE__ << std::endl; 
                throw err; 
            } 
            catch(...) 
            { 
                //std::cout << "Error while reading image " << i_name << std::endl; 
                throw; 
            } 
            //m_Iresults.push_back(reader->GetOutput()); 
    
      }

  /*    template <typename TImage> 
      void WxAnySimpleDlg::split3Din3Dvtk(TImage* i_Img)
      {
          typedef itk::ImageToVTKImageFilter< TImage > ConnectorType;
          typename ConnectorType::Pointer       connector = ConnectorType::New();
          connector->SetInput(i_Img);
          connector->GetImporter()->SetDataScalarTypeToUnsignedChar();
          connector->Update();
          vtkImageData *im = vtkImageData::New();
          im->ShallowCopy(connector->GetOutput());
          im->Update();
          m_Vresults.push_back(im);
      }*/


      template <typename TImage> 
      void WxAnySimpleDlg::split4Din3Dvtk(TImage* i_Img)
      {
          if(i_Img->GetImageDimension() == 4)
          {
              // size of fourth dimension 
              int dsize = i_Img->GetLargestPossibleRegion().GetSize(3);
              // Output Type
              typedef itk::Image<unsigned char,3> ImageOutputType;  
              typedef itk::ImageSeriesWriter<TImage, ImageOutputType >  SeriesWriterType;
              typedef itk::MetaImageIO MetaImageType;
              MetaImageType::Pointer metaIO;
              typename SeriesWriterType::Pointer seriesWriter = SeriesWriterType::New();
            
              // from JPR file to generate output files
              typedef itk::NumericSeriesFileNames NamesGeneratorType;
              NamesGeneratorType::Pointer namesGenerator = NamesGeneratorType::New();
              namesGenerator->SetStartIndex(0);
              namesGenerator->SetEndIndex(dsize-1); 
              namesGenerator->SetIncrementIndex(1);
              std::string format = m_dir;
              format += "/image%03d.mhd";
              namesGenerator->SetSeriesFormat( format.c_str() );
             
              const std::vector<std::string> names = namesGenerator->GetFileNames();
              seriesWriter->SetFileNames( names );
              seriesWriter->SetInput(i_Img);
              seriesWriter->SetImageIO(metaIO);
              try
              {
                 seriesWriter->Update();
                 vtkMetaImageReader *vReader = vtkMetaImageReader::New();
                 std::vector<std::string>::const_iterator it = names.begin();
                 for( ;it !=  names.end(); ++it)
                 {
                     vReader->SetFileName((*it).c_str());
                     vReader->Update();
                     m_Vresults.push_back(vReader->GetOutput());
                     
                 }
              }
              catch( itk::ExceptionObject & excp )
              {
                 std::cerr << "Exception thrown while writing the series " << std::endl;
                 std::cerr << excp << std::endl;
                 //return EXIT_FAILURE;
              }
          }
      }

      bool WxAnySimpleDlg::AllSameType()
      {
           if(m_AnyType.size() == 1)
           {
               return true;
           }
           else
           {
               return false;
           }

      }

 } // namespace end

