/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOWxAttributeSelectionPanel.h>
#include <creaImageIOSystem.h>

#include <creaImageIOGimmick.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#endif
namespace creaImageIO
{
	const int  ID_COMBO             = 180;
  // CTor
  WxAttributeSelectionPanel::WxAttributeSelectionPanel(wxWindow *parent, 
	  wxDialog* dial, 
	  WxGimmickView* view,
	  std::vector<std::string> sAtts,
	  std::vector<std::string> nsAtts,
	  int numLev)
 :   wxPanel( parent, 
		  -1, wxDefaultPosition, 
		  wxDefaultSize,
		  wxRESIZE_BORDER | 
	      wxSYSTEM_MENU  |
		  wxCLOSE_BOX |
		  wxMAXIMIZE_BOX | 
		  wxMINIMIZE_BOX | 
		  wxCAPTION  
	       ), 	
		   dialog(dial),
		   shownA(sAtts),
		   notShownA(nsAtts),
		   mView(view)
  {
    GimmickDebugMessage(1,"WxCustomizeConfigPanel::WxCustomizeConfigPanel"
			<<std::endl);
	/// \TODO fix warning: unused variable aa
	wxStaticText * aa = new wxStaticText(this,-1,_T(" Currently shown attributes for level: "), wxPoint(5,10));
	wxArrayString as;
	std::stringstream out;
	for(int i=1;i<=numLev;i++)
	{
		out<<i;
		as.Add(crea::std2wx(out.str()));
		out.str("");
	}
	levels=new wxComboBox(this, ID_COMBO,_T("1"),wxPoint(190, 5),wxDefaultSize,as);
	/// \TODO fix warning: unused variable na	
	wxStaticText * na=new wxStaticText(this,-1,_T(" Currently hidden attributes: "), wxPoint(255,10));

    shownAtts=new wxListCtrl(this, wxID_ANY, wxPoint(5,30), wxSize(160,90), wxLC_REPORT | wxLC_NO_HEADER );

	shownAtts->InsertColumn(0, 
				   crea::std2wx(""),
				   wxLIST_FORMAT_LEFT);
	shownAtts->SetColumnWidth(0,155);
	shownAtts->Show();

	wxButton *add = new wxButton(this,wxID_ANY,_T(">>"), wxPoint(170,50) );
	Connect( add->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxAttributeSelectionPanel::OnAdd ); 

	wxButton *remove = new wxButton(this,wxID_ANY,_T("<<"), wxPoint(170,70) );
	Connect( remove->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxAttributeSelectionPanel::OnRemove ); 
	
	notShownAtts=new wxListCtrl(this, wxID_ANY, wxPoint(255,30), wxSize(160,90), wxLC_REPORT | wxLC_NO_HEADER );

	notShownAtts->InsertColumn(0, 
				   crea::std2wx(""),
				   wxLIST_FORMAT_LEFT);
	notShownAtts->SetColumnWidth(0,155);
	notShownAtts->Show();
	LoadCtrls();

	wxButton *save = new wxButton(this,wxID_ANY,_T("Save Changes"), wxPoint(5,130) );
	Connect( save->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxAttributeSelectionPanel::OnSaveConfig ); 
   
    Layout(); 
  }

  /// Destructor
  WxAttributeSelectionPanel::~WxAttributeSelectionPanel()
  {
    GimmickDebugMessage(1,"WxAttributeSelectionPanel::~WxAttributeSelectionPanel"
			<<std::endl);
  }

  void WxAttributeSelectionPanel::OnSaveConfig(wxCommandEvent& event)
  {
	  int n=levels->GetSelection();
	  if(n<0){n=0;}
	  mView->OnAttributesChanged(notShownA,n);
	  dialog->Destroy();
  }

  void WxAttributeSelectionPanel::OnAdd(wxCommandEvent& event)
  {
	long item = -1;
	for ( ;; )
	{
		item = shownAtts->GetNextItem(item,
			wxLIST_NEXT_ALL,
			wxLIST_STATE_SELECTED);
		if ( item == -1 )
			break;
	
			std::string change = crea::wx2std(shownAtts->GetItemText(item));
			std::vector<std::string>::iterator it;
			bool found=false;
			for(it=shownA.begin();it!=shownA.end()&&!found;++it)
			{
				if((*it).compare(change)==0)
				{
					found=true;
				}
			}
			shownA.erase(it-1);
			notShownA.push_back(change);
	}
	LoadCtrls();
	
  }

  void WxAttributeSelectionPanel::OnRemove(wxCommandEvent& event)
  {

	long item = -1;
	for ( ;; )
	{
		item = notShownAtts->GetNextItem(item,
			wxLIST_NEXT_ALL,
			wxLIST_STATE_SELECTED);
		if ( item == -1 )
			break;
	
			std::string change = crea::wx2std(notShownAtts->GetItemText(item));
			std::vector<std::string>::iterator it;
			bool found=false;
			for(it=notShownA.begin();it!=notShownA.end()&&!found;++it)
			{
				if((*it).compare(change)==0)
				{
					found=true;
				}
			}
			notShownA.erase(it-1);
			shownA.push_back(change);
		
	}
	LoadCtrls();	
	  
  }
  

  void WxAttributeSelectionPanel::LoadCtrls()
  {

	  wxListItem item;
	    item.SetMask(wxLIST_MASK_STATE | 
			 wxLIST_MASK_TEXT |
			 //			 wxLIST_MASK_IMAGE |
			 wxLIST_MASK_DATA |
			 //			 wxLIST_MASK_WIDTH |
			 wxLIST_MASK_FORMAT
			 );
	std::vector<std::string>::iterator it;
	shownAtts->DeleteAllItems();
	notShownAtts->DeleteAllItems();
	for(it=shownA.begin();it!=shownA.end();++it)
	{
		item.SetText(crea::std2wx(*it));
		shownAtts->InsertItem(item);
	}

	
	for(it=notShownA.begin();it!=notShownA.end();++it)
	{
		item.SetText(crea::std2wx(*it));
		notShownAtts->InsertItem(item);
	}

  }
  void WxAttributeSelectionPanel::OnComboChange(wxCommandEvent& event)
  {
      int n=levels->GetSelection()+1;
	  mView->GetVisibleAttributes(shownA,notShownA,n);
	  LoadCtrls();
  }
  
//======================================================================
BEGIN_EVENT_TABLE(WxAttributeSelectionPanel, wxPanel)
EVT_COMBOBOX  (ID_COMBO,WxAttributeSelectionPanel::OnComboChange)
END_EVENT_TABLE()
//======================================================================

} // EO namespace creaImageIO


