/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOWxCustomizeConfigPanel.h>
#include <creaImageIOSystem.h>
namespace creaImageIO
{
  // CTor
  WxCustomizeConfigPanel::WxCustomizeConfigPanel(wxWindow *parent, wxDialog* dial, WxGimmickView* view, const std::string& cPath, 
		const std::string& dPath,
		const std::string& sEvent,
		const std::string& sFreq)
 :   wxPanel( parent, 
		  -1, wxDefaultPosition, 
		  wxDefaultSize,
		  wxRESIZE_BORDER | 
	      wxSYSTEM_MENU  |
		  wxCLOSE_BOX |
		  wxMAXIMIZE_BOX | 
		  wxMINIMIZE_BOX | 
		  wxCAPTION  
	       ), 	
		   dialog(dial),
		   copyP (cPath), 
		   databaseP(dPath), 
		   syncEv(sEvent), 
		   syncFr(sFreq),
		   mView(view)
  {
    GimmickDebugMessage(1,"WxCustomizeConfigPanel::WxCustomizeConfigPanel"
			<<std::endl);
	/// \TODO fix  warning: unused variable cp
        wxStaticText * cp=new wxStaticText(this,-1,_T(" Copy Path: "), wxPoint(5,10));
        copyPath=new wxTextCtrl(this, wxID_ANY, crea::std2wx(copyP), wxPoint(150,10), wxSize(250,20));

	/// \TODO fix  warning: unused variable dp
	wxStaticText * dp=new wxStaticText(this,-1,_T(" Database Path: "), wxPoint(5,40));
	dbPath=new wxTextCtrl(this, wxID_ANY, crea::std2wx(databaseP), wxPoint(150,40), wxSize(250,20));

	/// \TODO fix  warning: unused variable se
	wxStaticText * se=new wxStaticText(this,-1,_T(" Synchronization Event: "), wxPoint(5,70));
	syncEvent=new wxTextCtrl(this, wxID_ANY, crea::std2wx(syncEv), wxPoint(150,70), wxSize(250,20));

	/// \TODO fix  warning: unused variable sf
	wxStaticText * sf=new wxStaticText(this,-1,_T(" Synchronization Frequency: "), wxPoint(5,100));
	syncFrequency=new wxTextCtrl(this, wxID_ANY, crea::std2wx(syncFr), wxPoint(150,100), wxSize(250,20));

	wxButton *save = new wxButton(this,wxID_ANY,_T("Save Changes"), wxPoint(5,130) );
	Connect( save->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxCustomizeConfigPanel::OnSaveConfig ); 
  
    Layout(); 
  }

  /// Destructor
  WxCustomizeConfigPanel::~WxCustomizeConfigPanel()
  {
    GimmickDebugMessage(1,"WxCustomizeConfigPanel::~WxCustomizeConfigPanel"
			<<std::endl);
  }

  void WxCustomizeConfigPanel::OnSaveConfig(wxCommandEvent& event)
  {
	  mView->OnSaveSettingsCallback(crea::wx2std(copyPath->GetValue()),
		  crea::wx2std(dbPath->GetValue()),
		  crea::wx2std(syncEvent->GetValue()),
		  crea::wx2std(syncFrequency->GetValue()));
	  dialog->Destroy();
  }
  
//======================================================================
  
//====================================================================== 

} // EO namespace creaImageIO


