/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOWxDumpPanel.h>

#include <creaImageIOGimmick.h>
#include <boost/algorithm/string.hpp>
#if defined(USE_GDCM)
#include <gdcmGlobal.h>
#include <gdcmDictSet.h>
#include "gdcmFile.h"
#include "gdcmDocument.h"
#include "gdcmFileHelper.h"
#endif

#if defined(USE_GDCM2)
#include "gdcmGlobal.h"
#include "gdcmFile.h"
#include "gdcmDictPrinter.h"
#include "gdcmPrinter.h"
#include "gdcmReader.h"
#include "gdcmSmartPointer.h"
#include "gdcmSequenceOfItems.h"
#endif
#include "icons/save.xpm"

namespace creaImageIO
{
	// CTor
   WxDumpPanel::WxDumpPanel(wxWindow *parent,  std::string i_filename)
    : wxDialog(parent, -1,_T("DICOM TAGS"), wxDefaultPosition, wxSize(550,580)), filename(i_filename)
   {
	int size = 16;
	mIcon = new wxImageList(size,size,true);
	mIcon->Add(wxBitmap(wxBitmap(wxIcon(save_xpm)).ConvertToImage().Rescale(size, size)));
	wxToolBar *mToolBar = new wxToolBar(this,-1,wxDefaultPosition,wxDefaultSize);
	mToolBar->AddTool( DUMP_SAVE_ID,_T("Save"), mIcon->GetBitmap(0), _T("Save Dicom Tags in text file"));
	mToolBar->Realize();
	DumpText = new wxTextCtrl( this, wxID_ANY,_T(""), wxPoint(5,30), wxSize(520,510), wxTE_READONLY| wxMac | wxTE_MULTILINE | wxTE_RICH );
	Layout(); 
	Print();
	}

	// DTor
	WxDumpPanel::~WxDumpPanel(){}

	///////////////////////////////////////////////////
	/// Display in a control Text all dicom tags
	///////////////////////////////////////////////////
	void WxDumpPanel::Print()
	{
	   std::stringstream os;
	   std::string result = "";
	   if ( !filename.empty()) // ====== Deal with a single file ======
	   {

#if defined(USE_GDCM)
		   GDCM_NAME_SPACE::File *f = GDCM_NAME_SPACE::File::New();
		   f->SetLoadMode(GDCM_NAME_SPACE::LD_ALL);
		   f->SetFileName( filename );
		   f->SetMaxSizeLoadEntry(0xffff);
		   f->Load();
		   GDCM_NAME_SPACE::FileHelper *fh = GDCM_NAME_SPACE::FileHelper::New(f);
		      f->SetLoadMode(GDCM_NAME_SPACE::LD_NOSEQ |GDCM_NAME_SPACE::LD_NOSHADOW); 
		   fh->SetPrintLevel( 0 );
		   fh->Print(os);
		 
		   std::string line;
		   while(std::getline(os, line))
		   {
			  result +=clean(line.c_str());
			  result += "\n";
		   }
		   

#endif
#if defined(USE_GDCM2)
		  gdcm::Reader reader;
		  reader.SetFileName( filename.c_str() );
		  if (reader.Read())
		  {
			  gdcm::Printer printer;
			  printer.SetFile ( reader.GetFile() );
			  printer.SetColor( 0 );
			  printer.Print( os );
			  result = os.str();
		  }



	//const gdcm::DataSet& ds = reader.GetFile().GetDataSet();
 // // (5400,0100) SQ (Sequence with undefined length #=1)     # u/l, 1 WaveformSequence
	// gdcm::Tag twsq(0x5400,0x0100);
	// bool btest = ds.FindDataElement( twsq) ;
	//const gdcm::DataElement &wsq = ds.GetDataElement( twsq );
	// gdcm::SmartPointer<gdcm::SequenceOfItems> sqi = wsq.GetValueAsSQ();
	// int num = sqi->GetNumberOfItems();
 // 
 // const gdcm::Item & item = sqi->GetItem(1); // Item start at #1
 // const gdcm::DataSet& nestedds = item.GetNestedDataSet();

 // // (5400,1004) US 16                                       #   2, 1 WaveformBitsAllocated
 // gdcm::Tag twba(0x5400,0x1004);
 // if( !nestedds.FindDataElement( twba ) )
 //   {
 // 
 //   }
 // const gdcm::DataElement &wba= nestedds.GetDataElement( twba );

 // //std::cout << wba << std::endl;
 // //  (5400,1006) CS [SS]                                     #   2, 1 WaveformSampleInterpretation
 // // (5400,1010) OW 00ba\0030\ff76\ff8b\00a2\ffd3\ffae\ff50\0062\00c4\011e\00c2\00ba... # 57600, 1 WaveformData
 // gdcm::Tag twd(0x5400,0x1010);
 // if( !nestedds.FindDataElement( twd ) )
 //   {

 //   }
 // const gdcm::DataElement &wd = nestedds.GetDataElement( twd );
 // const gdcm::ByteValue *bv = wd.GetByteValue();
 // size_t len = bv->GetLength();
 // int16_t *p = (int16_t*)bv;
	// 
 // size_t npts = len / 2;
 // //npts = 10; // DEBUG !
 // for(size_t i = 0; i < npts; ++i )
 //   {
 //   float x;
 //   x = (float)p[i];
 //   }
 //// 
	//// gdcm::SmartPointer<gdcm::SequenceOfItems> sqi = wsq.GetValueAsSQ();
	////if( !sqi || !sqi->GetNumberOfItems() )
 ////   {
 ////   
 ////   }

 //// const gdcm::Item & item = sqi->GetItem(1); // Item start at #1
 //// const gdcm::DataSet& nestedds = item.GetNestedDataSet();

 //// // (5400,1004) US 16                                       #   2, 1 WaveformBitsAllocated
 //// gdcm::Tag twba(0x5400,0x1004);
 //// if( !nestedds.FindDataElement( twba ) )
 ////   {
 ////   return 0;
 ////   }
 //// const gdcm::DataElement &wba= nestedds.GetDataElement( twba );



	//	  gdcm::DataElement data = reader.GetFile().GetDataSet().GetDataElement(gdcm::Tag(0x5400,0x0100));
	//	  std::string seq_old_begin = "(fffe,e000) na (Item with undefined length)";
	//	  std::string seq_new_begin = "<SEQ>";
	//	  boost::algorithm::replace_all(result, seq_old_begin, seq_new_begin);
	//	  std::string seq_old_end = "(fffe,e00d)";
	//	  std::string seq_new_end = "<\\SEQ>";
	//	  boost::algorithm::replace_all(result, seq_old_end, seq_new_end);
		  //seq_old_end = "(fffe,e0dd)";		  boost::algorithm::replace_all(result, seq_old_end, "\n");
#endif
		  DumpText->SetValue(crea::std2wx(result));		   

		}
	}


	const std::string WxDumpPanel::clean(const std::string &i_line)
	{
		
		  if (i_line.substr(4,1) == "|")
			   {
				   std::string tag;
				   std::string line;
				   std::string signification;
				   std::string value;
				   std::string resultat;

				   tag = "(" + i_line.substr(0,9) + ")";
				   line =  i_line.substr(14,i_line.size()-10);
				   int pos1 = (int)line.find_first_of("[");
				   int pos2 = (int)line.find_first_of("]");
				   signification = line.substr(pos1+1, pos2-pos1-1);
				   line = line.substr(pos2+1);
				    pos1 = (int)line.find_first_of("[");
				    pos2 = (int)line.find_first_of("]");
				   value = line.substr(pos1+1, pos2-pos1-1);
				   resultat = tag + " " + signification + ": " +value;
				  return resultat;
			   }
		   else
		   {
			   return i_line;
		   }
	}

///////////////////////////////////////////////////	
/// wxEvent to save Dicom Tags in a text file	 //
///////////////////////////////////////////////////
	void WxDumpPanel::SaveInfos(wxCommandEvent& event)
	{
	wxFileDialog* FD = new wxFileDialog( 0,_T("Select file"), _T(""), _T(""),
					       crea::std2wx("*.txt"), wxOPEN, wxDefaultPosition);
        if (FD->ShowModal()==wxID_OK)
		{
			wxBusyCursor busy;
			std::ofstream ofs(crea::wx2std(FD->GetPath()).c_str());
			ofs.clear();
			ofs << crea::wx2std(DumpText->GetValue());;
			ofs.close();
		}
		Close();
	}

////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////
BEGIN_EVENT_TABLE(WxDumpPanel, wxDialog)
    EVT_TOOL(DUMP_SAVE_ID, WxDumpPanel::SaveInfos)
END_EVENT_TABLE()
}

