/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOWxEditFieldsPanel.h>
#include <creaImageIOSystem.h>
#include <wx/arrstr.h>

//using namespace tree;
namespace creaImageIO
{
   const int  ID_COMBO             = 140;
  // CTor
   WxEditFieldsPanel::WxEditFieldsPanel(wxWindow *parent, wxDialog* dial, WxGimmickView* view, tree::Node* nod, 
      const std::vector<std::string> name,
      const std::vector<std::string> key)
 :   wxPanel( parent, 
        -1, wxDefaultPosition, 
        wxDefaultSize,
        wxRESIZE_BORDER | 
        wxSYSTEM_MENU  |
        wxCLOSE_BOX |
        wxMAXIMIZE_BOX | 
        wxMINIMIZE_BOX | 
        wxCAPTION  
          ), 
        dialog(dial),
        node (nod), 
        names(name), 
        keys(key),
        mView(view)
  {
    GimmickDebugMessage(1,"WxCustomizeConfigPanel::WxCustomizeConfigPanel"
                       <<std::endl);
        /// \TODO fix warning: unused variable cp
	wxStaticText * cp=new wxStaticText(this,-1,_T(" Attribute to change: "), wxPoint(5,10));
	wxArrayString as;
	std::vector<std::string>::const_iterator it;
	for(it=names.begin();it!=names.end();++it)
	{
           as.Add(crea::std2wx(*it));
	}
	attributes=new wxComboBox(this, ID_COMBO, crea::std2wx(names.front()), wxPoint(110, 10), wxDefaultSize,as);
	std::string val=node->GetAttribute(keys[0]);
	if(val.compare("")==0){val="?";}

        /// \TODO fix warning: unused variable av
	wxStaticText * av=new wxStaticText(this,-1,_T(" Current Value: "), wxPoint(5,40));
	actualVal=new wxStaticText(this,-1,crea::std2wx(val), wxPoint(110,40));

        /// \TODO fix warning: unused variable nv
	wxStaticText * nv=new wxStaticText(this,-1,_T(" New Value: "), wxPoint(5,70));
	newVal=new wxTextCtrl(this, wxID_ANY, crea::std2wx(val), wxPoint(110,70), wxSize(220,20));

	wxButton *save = new wxButton(this,wxID_ANY,_T("Save Changes"), wxPoint(5,100) );
	Connect( save->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxEditFieldsPanel::OnEdit ); 
      
    Layout(); 
  }

  /// Destructor
  WxEditFieldsPanel::~WxEditFieldsPanel()
  {
    GimmickDebugMessage(1,"WxEditFieldsPanel::~WxEditFieldsPanel"
                 <<std::endl);
  }

  void WxEditFieldsPanel::OnEdit(wxCommandEvent& event)
  {
	  std::string val=crea::wx2std(newVal->GetValue());
	  int sel=attributes->GetSelection();
	  if(sel==-1)
	  {
	     sel=0;
	  }
	  mView->OnFieldsEdited(node,names[sel],keys[sel],val);
	  dialog->Destroy();
  }

  void WxEditFieldsPanel::OnComboChange(wxCommandEvent& event)
  {
	  std::string val=node->GetAttribute(keys[attributes->GetSelection()]);
	  if(val.compare("")==0){val="?";}
	  actualVal->SetLabel(crea::std2wx(val));
	  newVal->SetValue(crea::std2wx(val));
  }
  
//======================================================================
BEGIN_EVENT_TABLE(WxEditFieldsPanel, wxPanel)
EVT_COMBOBOX  (ID_COMBO,WxEditFieldsPanel::OnComboChange)
END_EVENT_TABLE()
//====================================================================== 

} // EO namespace creaImageIO

