/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#include <creaImageIOWxExportDlg.h>

namespace creaImageIO
{
	// CTor
   WxExportDlg::WxExportDlg(wxWindow *parent, const std::vector<std::string> storages)
    : wxDialog(parent, -1,_T("EXPORT FILES TO STORAGE"), wxDefaultPosition, wxSize(260,150))
   {
	  //int size = 16;

          /// \TODO fix warning: unused variable ExportText	
	  wxStaticText * ExportText=new wxStaticText(this,-1,_T(" Storage to export: "), wxPoint(5,10));
	  wxArrayString names;
	  std::vector<std::string>::const_iterator it = storages.begin();
	  for(;it != storages.end(); it++)
	  {
		  names.Add(crea::std2wx(*it));
	  }
	  ExportCombo  = new wxComboBox(this, ID_EXPORTCOMBO_CTRL,_T(""),wxPoint(120,10), wxSize(120,25),names);
	  ExportCombo->SetSelection(0);
	//  Connect( ExportCombo->GetId(), wxEVT_COMMAND_TEXT_UPDATED , (wxObjectEventFunction) &WxDescriptorPanel::OnDicomAttribute ); 

	  // VALIDATION BUTTON
	  wxButton *Ok = new wxButton(this, -1,_T("OK"), wxPoint(5,50) );
	  Connect( Ok->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxExportDlg::OnOk ); 

          /// \TODO fix warning: unused variable Cancel	
	  wxButton *Cancel = new wxButton(this, wxID_CANCEL,_T("CANCEL"), wxPoint(100,50) );
	  Layout(); 
	  
	}

	WxExportDlg::~WxExportDlg(){}

	void WxExportDlg::OnOk(wxCommandEvent &event)
	{
		m_name = crea::wx2std(ExportCombo->GetValue());
		Close();
		SetReturnCode(ID_EXPORT_OK);
	}	
}
