/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOWxGimmickFrame.h>
#include <creaImageIOSystem.h>
#include <creaImageIOGimmick.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#endif
namespace creaImageIO
{
  // CTor
  WxGimmickFrame::WxGimmickFrame(wxWindow *parent, 
					       wxWindowID id,
					       wxString title,
					       const wxPoint& pos,
					       const wxSize& size,
					       int threads)
 :   wxFrame( parent, 
		  id, 
		  title,
		  pos,
		  size,
		  wxRESIZE_BORDER | 
	      wxSYSTEM_MENU  |
		  wxCLOSE_BOX |
		  wxMAXIMIZE_BOX | 
		  wxMINIMIZE_BOX | 
		  wxCAPTION  
	       ),
    // mGimmick(0),
     mView(0)
  {
    GimmickDebugMessage(1,"WxGimmickFrame::WxGimmickFrame"
			<<std::endl);
    wxBoxSizer *topsizer = new wxBoxSizer(wxVERTICAL);
    
    try {
      
//		mGimmick = boost::shared_ptr<Gimmick>(new Gimmick());
      mGimmick->Initialize();
     
      int min_dim = GIMMICK_2D_IMAGE_SELECTION;
	  int max_dim = GIMMICK_3D_IMAGE_SELECTION;
      mView = new WxGimmickView(mGimmick,
				this,
				-1,
				wxDefaultPosition,
				size,
				min_dim,
				max_dim,
				threads);
      mView->Initialize();
    }
    catch (crea::Exception e)
    {
      e.Print();
      return;
    }

    topsizer->Add( mView,1,wxGROW,0);

    SetSizer( topsizer );     
    Layout(); 
  }

  /// Destructor
  WxGimmickFrame::~WxGimmickFrame()
  {
    GimmickDebugMessage(1,"WxGimmickFrame::~WxGimmickFrame"
			<<std::endl);
    if (mView) 
      {
	delete mView;
      }
    if (mGimmick) 
      {
	mGimmick->Finalize();
//	delete mGimmick;
      }
  }
  
  
  //================================================================
  //  BEGIN_EVENT_TABLE(WxGimmickFrame, wxDialog)
  //    END_EVENT_TABLE()
  //================================================================


} // EO namespace creaImageIO


