/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOWxGimmickReaderDialog.h>
#include <creaImageIOSystem.h>
#include <creaImageIOGimmick.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#endif
namespace creaImageIO
{
  // CTor
  WxGimmickReaderDialog::WxGimmickReaderDialog(wxWindow *parent, 
					       wxWindowID id,
					       const std::string i_namedescp, 
					       const std::string i_namedb,
					       wxString title,
					       const wxPoint& pos,
					       const wxSize& size,
					       int min_dim,
					       int max_dim,
					       int output_dim,  // never used ?!? // JPR
					       int threads)
 :   wxDialog( parent, 
		  id, 
		  title,
		  pos,
		  size,
		  wxRESIZE_BORDER | 
		  wxSYSTEM_MENU   |
		  wxCLOSE_BOX     |
		  wxMAXIMIZE_BOX  | 
		  wxMINIMIZE_BOX  | 
		  wxCAPTION  
	       ),
 //   mGimmick(0),
     mView(0)
  {
    GimmickDebugMessage(1,"WxGimmickReaderDialog::WxGimmickReaderDialog"
			<<std::endl);
    mtopsizer = new wxBoxSizer(wxVERTICAL);

    try {

	  mGimmick = boost::shared_ptr<Gimmick>(new Gimmick());
      mGimmick->Initialize(i_namedescp,i_namedb);

      mView = new WxGimmickView(mGimmick,
				this,
				TVID,
				wxDefaultPosition,
				size,
				min_dim,
				max_dim,
				threads);
      mView->Initialize();
	   // Connect the AddProgress callback
      mView->ConnectValidationObserver
      		( boost::bind( &WxGimmickReaderDialog::OnValid , this, _1 ) );
    }
    catch (crea::Exception e)
    {
      e.Print();
      return;
    }

    mtopsizer->Add( mView,1,wxGROW,0);

    wxSizer* bsizer = this->CreateSeparatedButtonSizer(wxOK|wxCANCEL);
	/*mOkButton = new wxButton(this, wxID_OK, _T("OK"), wxPoint(170,50));
	mCancelButton = new wxButton(this, wxID_CANCEL, _T("CANCEL"), wxPoint(210,50));
	*/	mOkButton = (wxButton*)FindWindowById(GetAffirmativeId(), this);
    mCancelButton = (wxButton*)FindWindowById(GetEscapeId(),      this);

    mOkButton->Enable(false);
    mtopsizer->Add ( bsizer, 0, wxGROW );

    SetSizer( mtopsizer );     
 
    Layout(); 
  }

  /// Destructor
  WxGimmickReaderDialog::~WxGimmickReaderDialog()
  {
    GimmickDebugMessage(1,"WxGimmickReaderDialog::~WxGimmickReaderDialog"
			<<std::endl);
    if (mView) 
      {
        delete mView;
      }
    if (mGimmick) 
      {
		mGimmick->Finalize();
      }

  }

  ///Callback method on a selection
  void WxGimmickReaderDialog::OnValid(bool t)
  {
    mOkButton->Enable(t);
  }

  //================================================================
  //BEGIN_EVENT_TABLE(WxGimmickReaderDialog, wxDialog)
  //END_EVENT_TABLE()
  //================================================================

} // EO namespace creaImageIO

