/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOWxGimmickTools.h>


namespace creaImageIO
{
	/**
	** Begin of the threshold panel
	**/
	WxGimmickTools::WxGimmickTools(wxWindow* parent, wxString mCurrentDirectory)
	 : wxPanel(parent, -1, wxDefaultPosition, wxSize(300,250), wxBORDER_SUNKEN)
	{
		_currentDir = mCurrentDirectory;
		_addFiles = true;
		_mhd      = false;

		_inputPath      = new wxTextCtrl(this, wxID_ANY, _T(""), wxDefaultPosition, wxSize(400,30));
		_outputPath     = new wxTextCtrl(this, wxID_ANY, _T(""), wxDefaultPosition, wxSize(400,30));
		_addCheckBox    = new wxCheckBox(this, -1,       _T("Add Images to Database?") );
		_mhdCheckBox    = new wxCheckBox(this, -1,       _T("Convert to MHD?") );
		_addCheckBox->SetValue(_addFiles);
		_mhdCheckBox->SetValue(_mhd);		

		wxButton *inputDir  = new wxButton(this, wxID_ANY,_T("Input Directory"),  wxDefaultPosition, wxSize(140,30) );
		wxButton *outputDir = new wxButton(this, wxID_ANY,_T("Output Directory"), wxDefaultPosition, wxSize(140,30) );

		Connect( inputDir->GetId(),     wxEVT_COMMAND_BUTTON_CLICKED ,  (wxObjectEventFunction) &WxGimmickTools::onInputDir ); 
		Connect( outputDir->GetId(),    wxEVT_COMMAND_BUTTON_CLICKED ,  (wxObjectEventFunction) &WxGimmickTools::onOutputDir );
		Connect( _addCheckBox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &WxGimmickTools::onAddToDatabase );
		Connect( _mhdCheckBox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &WxGimmickTools::onMHD );
		
		wxFlexGridSizer *textSizer = new wxFlexGridSizer(1,2);
		textSizer->Add( new wxStaticText(this, -1, _T("Transform a Bruker 'Serie'/'Study'/'set of Studies' directory into Dicom / MHD format.")), 1, wxGROW );
		textSizer->Add( new wxStaticText(this, -1, _T("If checkbox is selected images will be loaded into the DB.")), 1, wxGROW );

		wxFlexGridSizer *sizer	= new wxFlexGridSizer(2,5);
		sizer->Add( new wxStaticText(this, -1, _T(" ")), 1, wxGROW );
		sizer->Add( new wxStaticText(this, -1, _T(" ")), 1, wxGROW );
		sizer->Add( _inputPath,   1, wxGROW );
		sizer->Add( inputDir,     1, wxGROW );
		sizer->Add( _outputPath,  1, wxGROW );
		sizer->Add( outputDir,    1, wxGROW );
		sizer->Add( new wxStaticText(this, -1, _T(" ")), 1, wxGROW );
		sizer->Add( new wxStaticText(this, -1, _T(" ")), 1, wxGROW );
		sizer->Add( _addCheckBox, 1, wxGROW );
		sizer->Add( _mhdCheckBox, 1, wxGROW );
		
		wxFlexGridSizer *topSizer = new wxFlexGridSizer(1, 2);
		topSizer->Add( textSizer, 1, wxGROW );
		topSizer->Add( sizer,     1, wxGROW );
		this->SetSizer( topSizer );
		this->SetAutoLayout( true );
		this->Layout();
	}

	WxGimmickTools::~WxGimmickTools()
	{

	}

	wxString WxGimmickTools::getInputDir()
	{
		return _inputPath->GetValue();
	}

	wxString WxGimmickTools::getOutputDir()
	{
		return _outputPath->GetValue();
	}

	bool WxGimmickTools::getAddToDBCheckBoxValue()
	{
		return _addCheckBox->GetValue();
	}
	
	bool WxGimmickTools::getMHDCheckBoxValue()
	{
		return _mhdCheckBox->GetValue();
	}	

	void WxGimmickTools::onInputDir(wxCommandEvent& event)
	{
		long style = wxDD_DEFAULT_STYLE | wxDD_DIR_MUST_EXIST;
		wxDirDialog* FD = new wxDirDialog( 0, _T("Select the Input Directory"), _currentDir, style);
			      
		if (FD->ShowModal()==wxID_OK)
		{  
			_inputPath->SetValue(FD->GetPath());
		}
	}

	void WxGimmickTools::onOutputDir(wxCommandEvent& event)
	{
		long style = wxDD_DEFAULT_STYLE;
		wxDirDialog* FD = new wxDirDialog( 0, _T("Select the Output Directory"), _currentDir, style);
	    
		if (FD->ShowModal()==wxID_OK)
		{
			_outputPath->SetValue(FD->GetPath());
		}
	}

	void WxGimmickTools::onAddToDatabase(wxCommandEvent& event)
	{
		_addFiles = _addCheckBox->GetValue();
	}
	
	void WxGimmickTools::onMHD(wxCommandEvent& event)
	{
		_mhd = _mhdCheckBox->GetValue();
	}	

} // EO namespace creaImageIO


