/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#ifndef __creaImageIOWxIsimpleDlg_h_INCLUDED__
#define __creaImageIOWxIsimpleDlg_h_INCLUDED__


#include "creaImageIOSimpleView.h"
#include "itkImageToVTKImageFilter.h"
#include <creaWx.h>
#include <itkImageFileReader.h>
#include <boost/any.hpp>
namespace creaImageIO
{
 /**
   * \ingroup View
   */

	/// Simple Wxwidgets interface to select file(s) or directory or from creaImageIO database to display
	template <typename TImage> 
	class  __declspec(dllexport) WxISimpleDlg : public wxDialog
	{
	public:
		 /// Ctor
		  WxISimpleDlg( wxWindow *parent,  
			  wxString i_title =_T(""),
			  const std::string i_namedescp = "localdatabase_Descriptor.dscp",   
			  const std::string i_namedb   = "Local Database"     
			  );

		  ~WxISimpleDlg(){};

		  void setExts(std::vector<std::string>);
		  /// Callback to read file(s)
		  void OnReadFile(wxCommandEvent& event);

		  /// Callback to read directory, no recursive
		   void OnReadDirectory(wxCommandEvent &event);
	      
		  /// Callback to select from creaImageIO database
		   void OnReadGimmick(wxCommandEvent &event);

		   /// return a vtkImageData vector of selected images, if available
		   std::vector<vtkImageData*> getVtkImagesSelected() {return m_Vresults;}

			/// return a itkImage vector of selected images, if available
			std::vector<typename TImage::Pointer> getImagesSelected();
		

		   wxString getInfoImage();

		   void split4Din3Dvtk(const std::string &i_dir);
		   void split3Din3Dvtk( );
		   void set(bool i_dicom){m_dicom= i_dicom;}
		   std::vector <boost::any>& getAnyImages(){ return m_AnyImages;}
	private:

		std::vector<boost::any> m_AnyImages;
		std::vector<std::string> m_exts;
		std::string namedescp; 
		std::string namedb;
		wxString infoimage;
		bool m_dicom;
		/// interface to read data
		SimpleView m_view;
		 void readImg(const std::string &i_name);
		 void readDicomImg(const std::vector<std::string> &i_names);

		 std::vector <typename TImage::Pointer> m_Iresults;

		 std::vector <vtkImageData*> m_Vresults;

	};


}


#endif //__creaImageIOWxIsimpleDlg_h_INCLUDED__
