/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOWxListenerPanel.h>
#include <creaImageIOSystem.h>

namespace creaImageIO
{
  // CTor
  WxListenerPanel::WxListenerPanel(wxWindow *parent, wxDialog* dial, WxGimmickView* view, bool stat)
 :   wxPanel( parent, 
		  -1, wxDefaultPosition, 
		  wxDefaultSize,
		  wxRESIZE_BORDER | 
	      wxSYSTEM_MENU  |
		  wxCLOSE_BOX |
		  wxMAXIMIZE_BOX | 
		  wxMINIMIZE_BOX | 
		  wxCAPTION  
	       ), 	
		   dialog(dial),
		   mView(view)
  {
    GimmickDebugMessage(1,"WxListener::WxListener"
			<<std::endl);
	state=stat;
	/// \TODO fix warning: unused variable cp
	wxStaticText * cp=new wxStaticText(this,-1,_T(" Drive to monitor: "), wxPoint(5,15));
	const wxString choices[] = { _T("D:"), 
		_T("E:"), 
		_T("F:"), 
		_T("G:") };
	drives=new wxComboBox(this, -1,crea::std2wx("E:"),wxPoint(100, 10),wxDefaultSize,4,choices);

	addCheckBox = new wxCheckBox(this, -1, _T("Automatically add images to the database when CD/DVD is mounted?"), wxPoint(5,45) );
	addCheckBox->SetValue(true);
	removeCheckBox = new wxCheckBox(this, -1, _T("Automatically remove images from the database when CD/DVD is unmounted?"), wxPoint(5,75) );
	removeCheckBox->SetValue(true);
	Connect( addCheckBox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &WxListenerPanel::OnAdd );
	Connect( removeCheckBox->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &WxListenerPanel::OnRemove );
	std::string name;
	if (state){name="Start Monitoring Drive";}
	else {name="Stop Monitoring Drive";}
	wxButton *start = new wxButton(this,wxID_ANY,crea::std2wx(name), wxPoint(5,110) );
	Connect( start->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxListenerPanel::OnChangeThreadState ); 

	wxButton *save = new wxButton(this,wxID_ANY,_T("Save Changes"), wxPoint(130,110) );
	Connect( save->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxListenerPanel::OnChangeListenState ); 
  

    //topsizer->Add( mView,1,wxGROW,0);

//    SetSizer( topsizer );     
    Layout(); 
  }

  /// Destructor
  WxListenerPanel::~WxListenerPanel()
  {
    GimmickDebugMessage(1,"WxCustomizeConfigPanel::~WxCustomizeConfigPanel"
			<<std::endl);
  }

  void WxListenerPanel::OnAdd(wxCommandEvent& event)
  {
		addFiles = addCheckBox->GetValue();
  }

  void WxListenerPanel::OnRemove(wxCommandEvent& event)
  {
		removeFiles = removeCheckBox->GetValue();
  }

  void WxListenerPanel::OnChangeListenState(wxCommandEvent& event)
  {
	  mView->OnListenerCallback(crea::wx2std(drives->GetValue()),addFiles, removeFiles);
	  dialog->Destroy();
  }

  void WxListenerPanel::OnChangeThreadState(wxCommandEvent& event)
  {
	  if(state)
	  {
		mView->StartListeningThread();
	  }
	  else
	  {
		mView->StopListeningThread();
	  }
	  dialog->Destroy();
  }
  
//======================================================================
  
//====================================================================== 

} // EO namespace creaImageIO


