/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/


#include <creaImageIOWxOutputDlg.h>

namespace creaImageIO
{
	// CTor
   WxOutputDlg::WxOutputDlg(wxWindow *parent, const std::vector<std::string> filenames, int i_dim, bool single)
    : wxDialog(parent, -1,_T("OUTPUT FORMAT"), wxDefaultPosition, wxSize(350,450))
   {

		int size = (int)filenames.size();
		
		int deflt = 1;

		std::string sentence;
		sentence = "You select";
		std::string sentence2 = "You have the possibility to select output format :";
		//int nbsent= 0;
		std::vector<std::string> outsentences;
		if (size == 1)
		{
		   sentence += " 1 ";
		}
		else
		{
		   sentence += " n ";
		}
		if(single)
		{
			sentence += " single frames";
		}
		else
		{
			sentence += " multi-frames"; 
		}
		sentence += " as output";
	  
		
		if (size == 1)
		{
		  	if(single)
			{
				outsentences.push_back("It shall be a single file with a single 2D frmae");
			}
			else
			{
				outsentences.push_back("It shall be  multiple files with 2D frames");
				outsentences.push_back("It shall be a single file with 3D frames");
			}			
		}
		else
		{
		  	if(single)
			{
				outsentences.push_back("It shall be a single file with 3D frames");
				outsentences.push_back("It shall be  multiple files with 2D frames");
			}
			else
			{
				outsentences.push_back("It shall be a single file with (3D+t) frames");
				outsentences.push_back("It shall be  multiple (n+t) files with 2D frames");
				outsentences.push_back("It shall be  multiple (n) files with (2D+t) frames");
				outsentences.push_back("It shall be a multiple (t) files with (2D+n) frames");
				deflt = 3;
			}
		
		}
		if(i_dim != -1)
		{
			deflt = i_dim;
		}


	  int start_point = 45;
	  /// \TODO fix unused variable ExportText
	  wxStaticText * ExportText=new wxStaticText(this,-1,crea::std2wx(sentence), wxPoint(5,10));
	  
	  std::vector<std::string>::iterator it = outsentences.begin();
	  for(int i = 0;it != outsentences.end(); it++, i++, start_point += 45)
	  {
		 wxCheckBox *check = new wxCheckBox(this, -1, crea::std2wx((*it)), wxPoint(5,start_point) );
		 if(i == deflt)
			 check->SetValue(true);
		 else
			 check->SetValue(false);
		  Connect( check->GetId(), wxEVT_COMMAND_CHECKBOX_CLICKED, (wxObjectEventFunction) &WxOutputDlg::OnChange );
		  checkOut.push_back(check);
	  }
	  
	 checkAsking = new wxCheckBox(this, -1, _T("Do you want to save this output and no more asking"), wxPoint(5,start_point) );

	  // VALIDATION BUTTON
	  wxButton *Ok = new wxButton(this, -1,_T("OK"), wxPoint(5,start_point+20) );
	  
	  Connect( Ok->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxOutputDlg::OnOk );
	  
	  /// \TODO fix unused variable	Cancel
	  wxButton *Cancel = new wxButton(this, wxID_CANCEL,_T("CANCEL"), wxPoint(100,start_point+20) );
	  Layout(); 
	  
	}

	WxOutputDlg::~WxOutputDlg(){}

	void WxOutputDlg::OnOk(wxCommandEvent &event)
	{
		Close();
		SetReturnCode(wxID_OK);
	}	

	void WxOutputDlg::OnChange(wxCommandEvent& event)
	{
		std::vector<wxCheckBox*>::iterator it = checkOut.begin();

		for(int i = 0;it != checkOut.end(); it++, i++)
		{
			if( (*it)->GetId() == event.GetId())
			{
			}
			else
			{
				(*it)->SetValue(false);
			}
		}
	}

	const std::string WxOutputDlg::getDim()
	{
		char res[2];
		std::vector<wxCheckBox*>::iterator it = checkOut.begin();
	    for(int i = 1;it != checkOut.end(); it++, i++)
	    {
			if( (*it)->GetValue() )
			{
				sprintf(res,"%d", i);
			}
			else
			{
				
			}
		}
		return res;
	}
	const std::string WxOutputDlg::getAsking()
	{ 
		if(checkAsking->GetValue())
			return "false";	
		else
			return "true";
	}
}
