/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#include <creaImageIOWxPACSConnectionPanel.h>
#include <creaImageIOPACSConnection.h>
#include <creaImageIOSystem.h>
#if defined (USE_GDCM2)
#include "gdcmCompositeNetworkFunctions.h"
#endif
namespace creaImageIO
{
  // CTor
  WxPACSConnectionPanel::WxPACSConnectionPanel(wxWindow *parent, wxDialog* dial, WxGimmickView* view)
 :   wxPanel( parent, 
		  -1, wxDefaultPosition, 
		  wxDefaultSize,
		  wxRESIZE_BORDER | 
	          wxSYSTEM_MENU  |
		  wxCLOSE_BOX |
		  wxMAXIMIZE_BOX | 
		  wxMINIMIZE_BOX | 
		  wxCAPTION  
	       ), 	
		   dialog(dial),
		   mView(view)
  {
    GimmickDebugMessage(1,"WxPACSConnectionPanel::WxPACSConnectionPanel"
			<<std::endl);
	/// \TODO fix  warning: unused variable dicId aet pn adv1 ad
	wxStaticText * dicId=new wxStaticText(this,-1,_T(" DICOM Identification: "), wxPoint(5,5));
	wxStaticText * aet=new wxStaticText(this,-1,_T(" AETitle: "), wxPoint(5,25));
	aeTitle=new wxTextCtrl(this, wxID_ANY, _T("MyAeTitle"), wxPoint(75,25), wxSize(220,20));

	wxStaticText * pn=new wxStaticText(this,-1,_T(" Port Number: "), wxPoint(5,53));
	pNumber=new wxTextCtrl(this, wxID_ANY, _T("3306"), wxPoint(75,50), wxSize(220,20));
	wxStaticText * adv1=new wxStaticText(this,-1,_T(" (1 - 131072) "), wxPoint(300,53));

	wxStaticText * ad=new wxStaticText(this,-1,_T(" Address: "), wxPoint(5,80));
	address=new wxTextCtrl(this, wxID_ANY, _T("localhost"), wxPoint(75,75), wxSize(220,20));
	
	wxButton *query = new wxButton(this,wxID_ANY,_T("Query PACS Server"), wxPoint(5,110) );
	Connect( query->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxPACSConnectionPanel::OnQueryPACS ); 
   
    Layout(); 
  }

  /// Destructor
  WxPACSConnectionPanel::~WxPACSConnectionPanel()
  {
    GimmickDebugMessage(1,"WxPACSConnectionPanel::~WxPACSConnectionPanel"
			<<std::endl);
  }

  void WxPACSConnectionPanel::OnQueryPACS(wxCommandEvent& event)
  {
	  #if defined (USE_GDCM2)
	    bool didItWork = gdcm::CompositeNetworkFunctions::CEcho( crea::wx2std(address->GetValue()).c_str(), 3600,
			"CREATIS", crea::wx2std(aeTitle->GetValue()).c_str() );
		  gdcm::Tag tag;
		  tag.ReadFromCommaSeparatedString("10,10"); 
		/*  tag.SetElement(8);
		  tag.SetGroup(8);*/
		std::vector< std::pair<gdcm::Tag, std::string> > keys;

		std::pair<gdcm::Tag, std::string> pa;
		pa.first = tag;
		pa.second = "";
		keys.push_back(std::make_pair(tag, ""));
			gdcm::EQueryLevel theLevel  = gdcm::ePatient;
		gdcm::ERootType theRoot  = gdcm::ePatientRootType;
		    gdcm::SmartPointer<gdcm::BaseRootQuery> theQuery =  gdcm::CompositeNetworkFunctions::ConstructQuery(theRoot, theLevel ,keys);

	
		    std::vector<gdcm::DataSet> theDataSet;
  gdcm::CompositeNetworkFunctions::CFind(crea::wx2std(address->GetValue()).c_str(), 3600, theQuery, theDataSet,
       "CREATIS", crea::wx2std(aeTitle->GetValue()).c_str());
#endif
  }
  
//======================================================================
  
//====================================================================== 

} // EO namespace creaImageIO


