/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#include "creaImageIOWxSimpleDlg.h"


namespace creaImageIO
{


	///Ctor
   WxSimpleDlg::WxSimpleDlg(wxWindow *parent, 
                            wxString i_title,  
                            const std::string i_namedescp , 
                            const std::string i_namedb)
    : wxDialog(parent, -1,_T("SELECT IMAGE(S)"), wxDefaultPosition, wxSize(230,150))
   {
		namedescp	= i_namedescp; 
		namedb		= i_namedb;

	   if(!i_title.empty())
	   {
			this->SetTitle(i_title);  
	   }
	   // Button to select file(s)
	   wxButton *fileBut = new wxButton(this, -1,_T("Select a single file"), wxPoint(10,7) );
  	   Connect( fileBut->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxSimpleDlg::OnReadFile ); 

	   // Button to select directory
	   wxButton *directoryBut = new wxButton(this, -1,_T("Select all the files in a directory"), wxPoint(10,40) );
	   Connect( directoryBut->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxSimpleDlg::OnReadDirectory ); 

	   // button to select creaImageIO
	   wxButton *gimmickBut = new wxButton(this, -1,_T("Select thru Dicom browser"), wxPoint(10,70) );
	   Connect( gimmickBut->GetId(), wxEVT_COMMAND_BUTTON_CLICKED , (wxObjectEventFunction) &WxSimpleDlg::OnReadGimmick ); 

	   /// \TODO  Button to select Bruker directory
	   bInfo = false;
	Layout(); 
	
	}
//////////////////////////////////////////////////////////////////////
//                                                                  //
//////////////////////////////////////////////////////////////////////
	  void WxSimpleDlg::OnReadFile(wxCommandEvent& event)
	  {
		  int resultShowModal;
		  wxFileDialog* fileDlg = new wxFileDialog( 0,  _T("Select file"), _T(""), _T(""), crea::std2wx("*"), wxOPEN |wxFD_MULTIPLE, wxDefaultPosition);
    
		    resultShowModal = fileDlg->ShowModal();
			if ( resultShowModal==wxID_OK )
			{
				wxArrayString wxArray;
				fileDlg->GetPaths(wxArray);
				if(wxArray.size() >0)
				{
					m_results.clear();
					infoimage		=	wxArray[0];
					infoimageSource	=	_T("FILE(s)");
					std::vector<std::string> files;
					for( int i = 0; i < wxArray.GetCount(); i++)
					{
						files.push_back( crea::wx2std(wxArray[i]));
					}
					if( !m_view.readFile(files , m_attrDicomTags , m_resultsDicomAtr , m_results) )
					{
						//TO DO WARNING MESSAGE;
					}
				} else {
					// TO DO WARNING MESSAGES
				}
			}
		  SetReturnCode( resultShowModal );
//		 Close();
		 EndModal( resultShowModal );
	  }

 //////////////////////////////////////////////////////////////////////
//																	//
//////////////////////////////////////////////////////////////////////

	  void WxSimpleDlg::OnReadDirectory(wxCommandEvent &event)
	  {
		  int resultShowModal;
	     long style = wxDD_DEFAULT_STYLE | wxDD_DIR_MUST_EXIST;
		 wxDirDialog* dirDlg = new wxDirDialog( 0, _T("Select the directory to display"), _T(""), style);
		 
		 resultShowModal = dirDlg->ShowModal();
		 if ( resultShowModal==wxID_OK )
		 {  
			 m_results.clear();
			infoimage		=	dirDlg->GetPath();
			infoimageSource	=	_T("DIRECTORY");
			if(! m_view.readDirectory(crea::wx2std(dirDlg->GetPath()) , m_attrDicomTags , m_resultsDicomAtr , m_results))
			{
				//TO DO WARNING MESSAGE;
			}
		 }
		 SetReturnCode( resultShowModal );
//		 Close();
		 EndModal( resultShowModal );
	  }

	  //////////////////////////////////////////////////////////////////////
//																	//
//////////////////////////////////////////////////////////////////////

	  void WxSimpleDlg::OnReadGimmick(wxCommandEvent &event)
	  {
		  // Run Gimmick
		   WxGimmickReaderDialog dlg(0,-1, 
				   namedescp,
				   namedb, 
				   _T("Select image(s)        - Gimmick! (c) CREATIS-LRMN 2008"),
                   wxDefaultPosition,
                   wxSize(810,750),
                   GIMMICK_2D_IMAGE_SELECTION,
                   GIMMICK_3D_IMAGE_SELECTION,
                   _3D,
				   1);
		 dlg.ShowModal();
		 if (dlg.GetReturnCode() == wxID_OK)
	     {
				dlg.stopReading();

				std::vector<creaImageIO::OutStrGimmick> outStrGimmick;
				dlg.getSelected(outStrGimmick, m_attrDicomTags,true,"");

			m_results.clear();
			int size=(int)outStrGimmick.size();
			int ii;
//			if(!bInfo)
//			{
				for (ii=0;ii<size;ii++)
				{
					m_results.push_back(outStrGimmick[ii].img);
					m_resultsDicomAtr.push_back( outStrGimmick[ii].infos );
				}
//			} else {
//				for (ii=0;ii<size;ii++)
//				{
//					m_resultsInfo.push_back(outStrGimmick[ii]);
//				}
//			}

			infoimage		=	_T("EED Missing info <void> ???");
			infoimageSource	=	_T("GIMMICK");

			dlg.OnExit();
		 }
		 SetReturnCode( dlg.GetReturnCode() );
		 EndModal( dlg.GetReturnCode() );
	   }

//-----------------------------------------------------------------------------   
	wxString WxSimpleDlg::getInfoImage()
	{
		return infoimage;
	}

//-----------------------------------------------------------------------------   
	wxString WxSimpleDlg::getInfoImageSource()
	{
		return infoimageSource;
	}

 //////////////////////////////////////////////////////////////////////
// Return the results vector										//
//////////////////////////////////////////////////////////////////////
	  std::vector<vtkImageData*> WxSimpleDlg::getImagesSelected()
	  {
		  return m_results;
	  }

//-----------------------------------------------------------------------------   
	std::vector< std::map<std::string, std::string> >  WxSimpleDlg::getDicomInfoImagesSelected()
	{
		return m_resultsDicomAtr;
	}

//-----------------------------------------------------------------------------   
	void WxSimpleDlg::SetAttrDicomTags( std::vector<std::string> attr )
	{
		m_attrDicomTags=attr;
	}
	  

//-----------------------------------------------------------------------------   
	vtkImageData*  WxSimpleDlg::getVolumeSelected()
	{
		vtkImageData *result;

//        creaImageIO::WxSimpleDlg dlg(0,crea::std2wx(bbGetInputTitle()),"localdatabase_Descriptor.dscp","Local Database"); 
//		dlg.SetAttrDicomTags( bbGetInputDicomTags() );
//		dlg.ShowModal(); 
//		bbSetOutputDicomInfo( dlg.getDicomInfoImagesSelected() );

		if (getImagesSelected().size()!=0){ 
//		  bbSetOutputFileName( std::string( dlg.getInfoImage().mb_str() ) );
		  if(getImagesSelected().size() ==1)
		  {
			result = getImagesSelected()[0] ;  
		  } else {
				// FCY: it will be a big problem if we have several kind of data in the same folder.
			  	// creation of a huge vtkImageData!!!!
			  	vtkImageData* first = getImagesSelected()[0];
			  	int dim[3];
			  	first->GetDimensions(dim);
			  	if (dim[2]==1)
				{
					vtkImageData *out;
				  	out  = vtkImageData::New();
				  	out->SetScalarType(first->GetScalarType());
				  	out->SetNumberOfScalarComponents(first->GetNumberOfScalarComponents());
				  	int ext[6];
				  	first->GetWholeExtent(ext); 
				  	if(ext[5] == 0)
				  	{
				 	   ext[5] = getImagesSelected().size()-1;
				 	 } else {
						ext[5] = ext[5] * getImagesSelected().size()-1; // to deal with multiframes 
				  	} // ext
				  	out->SetExtent(ext);
				  	double spac[3];
				  	first->GetDimensions(dim);
				  	first->GetSpacing(spac);
 				  	if (spac[0]==spac[1])
					{
						spac[2]=spac[0];  
		          	}
					out->SetSpacing(spac);
					out->SetDimensions(dim[0], dim[1], getImagesSelected().size() );
					out->AllocateScalars();
					out->Update();
					unsigned long imsize = dim[0] * dim[1];
					imsize = imsize * dim[2];  // deal with multiframes here
					// differents formats char , short, etc...
					// differents components 1..3  ex. jpg ->RGB 3
					imsize = imsize * first->GetScalarSize() * first->GetNumberOfScalarComponents();
  		        	int slice,sizeImageVector=getImagesSelected().size();
					for (slice=0 ; slice<sizeImageVector ; slice++)
					{
						vtkImageData *img = getImagesSelected()[slice];
						memcpy(out->GetScalarPointer(0,0,slice), img->GetScalarPointer(0,0,0), imsize);
						//img->Delete();
				 	} // for slice	

//EED This is NOT working. The iteration over the pointer vtkImageData
//		    	  	int slice=0;
//		  	    	std::vector<vtkImageData*>::iterator it;
//		  	    	for (it=dlg.getImagesSelected().begin(); it!=dlg.getImagesSelected().end(); ++it) 
//					{
//						  memcpy(out->GetScalarPointer(0,0,slice), (*it)->GetScalarPointer(0,0,0), imsize);
//						  slice++;
//					}	
//		     	  	//for (it=dlg.getImagesSelected().begin(); it!=dlg.getImagesSelected().end(); ++it) 
//					//{
// 					//		(*it)->Delete();
//					//}

					result =out;

				} else {
					result = first;
				} // dim
			} // if getImagesSelected size
		} else { 
	    	result = NULL;  
		} // getImagesSelected().size()!=0


        	return result;

		}



} // namespace creaImageIO

