/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#include "creaImageIOSimpleView.h"

#include "creaImageIOWxGimmickReaderDialog.h"
namespace creaImageIO
{
 /**
   * \ingroup View
   */

	/// Simple Wxwidgets interface to select file(s) or directory or from creaImageIO database to display
	class CREAIMAGEIO_EXPORT WxSimpleDlg : public wxDialog
	{
	public:
		 /// Ctor
		  WxSimpleDlg( wxWindow *parent,  
			  wxString i_title =_T(""),
			  const std::string i_namedescp = "localdatabase_Descriptor.dscp",   
			  const std::string i_namedb   = "Local Database"     
			  );
		  ///Dtor
		  ~WxSimpleDlg(){};

		  /// Callback to read file(s)
		  void OnReadFile(wxCommandEvent& event);

		  /// Callback to read directory, no recursive
		   void OnReadDirectory(wxCommandEvent &event);
	      
		  /// Callback to select from creaImageIO database
		   void OnReadGimmick(wxCommandEvent &event);

		   /// return a vtkImageData vector of selected images, if available
		   std::vector<vtkImageData*> getImagesSelected();
		   vtkImageData* getVolumeSelected();

		   wxString getInfoImage();
		   wxString getInfoImageSource();

		   std::vector< std::map<std::string,std::string> >  getDicomInfoImagesSelected();
		   void SetAttrDicomTags( std::vector<std::string> attr );


		   void setInfo(bool i_val){bInfo = i_val;}
		   
		   // OutStrGimmick:
		   //	- vtkImageData *
		   //	- std::map<std::string, std::string> mapDicomInfos (std::map<tag Dicom, Value>
		   std::vector<creaImageIO::OutStrGimmick> getMapInfos(){return m_resultsInfo;}

	private:
		bool 							bInfo;
		std::string 						namedescp; 
		std::string 						namedb;
		wxString 						infoimage;
		wxString 						infoimageSource;

		/// interface to read data
		SimpleView 						m_view;

		/// vtkImageData vector
		std::vector<vtkImageData*> 				m_results;
		std::vector< std::map<std::string,std::string> > 	m_resultsDicomAtr;
		std::vector<std::string> 				m_attrDicomTags;    // DXXXX_YYYY DAAAA_BBBB ...

		std::vector<creaImageIO::OutStrGimmick> m_resultsInfo;
		
	};
}
