/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#ifndef __creaImageIOWxViewer_h_INCLUDED__
#define __creaImageIOWxViewer_h_INCLUDED__

#ifdef USE_WXWIDGETS

// wx
#include <creaWx.h>
#include <wx/image.h>
#include <wx/imaglist.h>
#include <wx/splitter.h>


#include <creaImageIOImagePointerHolder.h>

// For image preview 
// vtk and wxvtk classes
#include "creawxVTKRenderWindowInteractor.h"
#include "vtkImageViewer2.h"

namespace creaImageIO
{

  class WxViewerPlayer;

  class WxViewer : public wxPanel
  {
 
  public:
    /// Ctors 
    WxViewer();
    WxViewer(wxWindow *parent, 
		   const wxWindowID id,
		   wxString title,
		   const wxPoint& pos, 
		   const wxSize& size);
    /// Dtor
    virtual ~WxViewer();
    /// Shows the next image in the image vector
    void ShowNextImage();
	///Starts the image player
	void StartPlayer();
	///Stops the image player
    void StopPlayer();
	///Refreshes the interface if the current image shown has changed
    bool RefreshIfNecessary();
	///Sets a new image vector to be read
	void SetImageVector(std::vector<boost::shared_ptr<ImagePointerHolder> > &pointers);

	/// Set value of slider control
	void SetValue();

  private:

    /// Event to resume or start cine loop
	void OnCineLoop(wxCommandEvent &Event);

	/// Event to change displayed frames with slide control
	void OnSlide(wxCommandEvent &Event);


    ///Shows the image passed as parameter
    void ShowImage(vtkImageData* im);
    /// Previewer
    vtkImageViewer2* mViewer;

	///Slider
	wxSlider *mslide ;

	///CheckBox to cine loop
	wxCheckBox  *mcheck;

    /// Associated wxvtk interactor
	crea::creawxVTKRenderWindowInteractor  *mInteractor;
	
    /// Current extent 
    int mx1,mx2,my1,my2,mz1,mz2;
    /// Current spacing
    double mspx,mspy,mspz;
    /// Current image shown
    int mCurrent;
    ///The threaded movie player
    WxViewerPlayer* mPlayer;
    /// The mutex
    wxMutex mMutex;
    /// Boolean that declares if the player needs to be refreshed
    bool mNeedRefresh;
	///Last image shown
    vtkImageData* mLastImageShown;
	///The vectors of images to be shown
	std::vector< boost::shared_ptr<ImagePointerHolder> > imagePointers;

	/// Sizers to preview images 
	wxFlexGridSizer *mflexSizer;
	wxBoxSizer *mtopSizer;

  };

}

#endif // USE_WIDGETS
// EOF
#endif  
