/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Sant)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
*/

#include <creatisIOComparator.h>

namespace creaImageIO{

	Comparator::Comparator(tree::Node *i_tree, std::string i_tag) : m_discr(i_tag): bdiscr(false)
	{
		std::map< std::string, std::string>  attr;
		i_tree->GetDescriptor().BuildAttributeMap(attr);
		std::map<std::string, std::string>::iterator it_att = attr.begin();
		for(; it_att != attr.end(); it_att++)
		{
			if (it_att->first == m_discr)
			{
				bdiscr = true;
				break;
			}
		}
		tree::Node::ChildrenListType::reverse_iterator j;
	for (j = (*i)->GetChildrenList().rbegin(); 
	     j!= (*i)->GetChildrenList().rend(); 
	     ++j)
	  {
	    GimmickDebugMessage(1,
				"adding children "
				<<(*j)->GetLabel()
				<<"'"
				<<std::endl);
	    
	    wxListItem item;
	    item.SetMask(wxLIST_MASK_STATE | 
			 wxLIST_MASK_TEXT |
			 //			 wxLIST_MASK_IMAGE |
			 wxLIST_MASK_DATA |
			 //			 wxLIST_MASK_WIDTH |
			 wxLIST_MASK_FORMAT
			 );
	    
		ItemData* data = new ItemData();
	    data->node = *j;
	    data->id = _id;
		
	    item.SetId(_id);
	    item.SetData(data);

	    _id++;
	    GetCtrl(l)->InsertItem(item);
	    
	    //Setting attributes
	    for (int k=0; k<GetCtrl(l)->GetColumnCount(); ++k)				
	      {
		std::string val;
		//  Temporary correction : it works but no explanation about the problem FCY
		
		if(k==0 && level <3)
		{
		  val = (*j)->GetAttribute("NumberOfChildren");
		}
		else
		  val = (*j)->GetAttribute(mLevelList[l].key[k]);
		
	}
}