/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

#include "wx/wx.h"
#include "wxMaracas_N_ViewersWidget.h"
#include "OpenImageDialog.h"
#include "vtkImageData.h"

#include <structBCPSettings.h>
#include <buttonContainerSettings.h>
#include <creaPanelButtonContainer.h>

class MyApp:public wxApp
{
public:
	virtual bool OnInit();
};

class MyFrame:public wxFrame
{
public:

	MyFrame(const wxString& title);

	void OnQuit(wxCommandEvent& event);
	void OnOpen(wxCommandEvent& event);
	void OnAbout(wxCommandEvent& event);
	//void SimpleSliderDialog();

private:

	//bbwx::Slider::Pointer mSlider;
//	bbcreaMaracasVisu::bbmaracasVisuViewerNV::Pointer viewer;
	vtkImageData* image;
	wxWindow* viewer;
	DECLARE_EVENT_TABLE()

};

DECLARE_APP(MyApp)

IMPLEMENT_APP(MyApp)

bool MyApp::OnInit()
{
	MyFrame *frame = new MyFrame(wxT("CREATIS basic"));

	const int width = 600;

	const int height = 250;

	frame->SetSize(width,height);

	frame->Show(true);

	return true;
}

BEGIN_EVENT_TABLE(MyFrame,wxFrame)
	EVT_MENU(wxID_ABOUT,MyFrame::OnAbout)
	EVT_MENU(wxID_OPEN,MyFrame::OnOpen)
	EVT_MENU(wxID_EXIT,MyFrame::OnQuit)
END_EVENT_TABLE()


void MyFrame::OnOpen(wxCommandEvent& event)
{
	//wxMessageBox(wxT("You clicked the open option"));

			creaMaracasVisuKernel::OpenImageDialog *diag = new creaMaracasVisuKernel::OpenImageDialog(true);
			 wxBoxSizer *sizer = new wxBoxSizer(wxVERTICAL);

			if(diag->getImageData() != NULL){
				std::vector<int>* vectype;
				vectype = new std::vector<int>();
				vectype->push_back(5);
				vectype->push_back(0);
				viewer = new wxMaracas_N_ViewersWidget(this,diag->getImageData(), vectype);
			sizer->Add(viewer,1,wxGROW);
			  SetSizer(sizer);
			}
}

void MyFrame::OnAbout(wxCommandEvent& event)
{
	
}

void MyFrame::OnQuit(wxCommandEvent& event)
{
	Close();
}

MyFrame::MyFrame(const wxString& title):wxFrame(NULL,wxID_ANY,title)
{

	
	// viewer = bbcreaMaracasVisu::bbmaracasVisuViewerNV::New("Viewer");
	//mSlider = bbwx::Slider::New("slider");
	//mSlider->bbUserCreateWidget(this);


	//sizer->Add(mSlider->bbGetOutputWidget(),1,wxGROW);



	wxMenu *fileMenu = new wxMenu;

	wxMenu *helpMenu = new wxMenu;

	helpMenu->Append(wxID_ABOUT,wxT("&About...\tF1"),wxT("Show about dialog"));

	fileMenu->Append(wxID_OPEN,wxT("&O&pen\tAlt-O"),wxT("Open Files"));
	fileMenu->Append(wxID_EXIT,wxT("&E&xit\tAlt-X"),wxT("Quit"));


	wxMenuBar *menuBar = new wxMenuBar();
	menuBar->Append(fileMenu,wxT("&File"));
	menuBar->Append(helpMenu,wxT("&Help"));

	SetMenuBar(menuBar);

	 // SetAutoLayout(true);
	/*CreateStatusBar(2);
	SetStatusText(wxT("CREATIS"));*/
}

