/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Sant�)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */

/*=========================================================================

Program:   ManualPaint
Module:    creaMaracasVisu
Language:  C++

=========================================================================*/

#include <vtkMetaImageReader.h>
#include "ManualPaintModel.h"
#include "wxManualPaintPanel.h"

#include "wx/wx.h"

class MyApp;
class MyFrame;

// Define a new application type, each program should derive a class from wxApp
class MyApp : public wxApp
{
public:
    // this one is called on application startup and is a good place for the app
    // initialization (doing it here and not in the ctor allows to have an error
    // return: if OnInit() returns false, the application terminates)
    virtual bool OnInit();
};

// Define a new frame type: this is going to be our main frame
class MyFrame : public wxFrame
{
public:
    // ctor(s)
    MyFrame(const wxString& title, const wxPoint& pos, const wxSize& size);
    ~MyFrame();

    // event handlers (these functions should _not_ be virtual)
    void OnQuit(wxCommandEvent& event);

private:

//	wxRenderWindow *MyRenderWindow;


private:
    // any class wishing to process wxWindows events must use this macro
    DECLARE_EVENT_TABLE()
};

// IDs for the controls and the menu commands
enum
{
    // menu items
    Minimal_Quit = 1,
    Minimal_About
};

#define MY_FRAME      101
#define MY_VTK_WINDOW 102

// the event tables connect the wxWindows events with the functions (event
// handlers) which process them. It can be also done at run-time, but for the
// simple menu events like this the static method is much simpler.
BEGIN_EVENT_TABLE(MyFrame, wxFrame)
    EVT_MENU(Minimal_Quit,  MyFrame::OnQuit)
END_EVENT_TABLE()

// Create a new application object: this macro will allow wxWindows to create
// the application object during program execution (it's better than using a
// static object for many reasons) and also declares the accessor function
// wxGetApp() which will return the reference of the right type (i.e. MyApp and
// not wxApp)
IMPLEMENT_APP(MyApp)

// 'Main program' equivalent: the program execution "starts" here
bool MyApp::OnInit()
{
    // create the main application window
    MyFrame *frame = new MyFrame(_T("wxWindows-VTK App"),
                                 wxPoint(50, 50), wxSize(450, 340));

    // and show it (the frames, unlike simple controls, are not shown when
    // created initially)
    frame->Show(TRUE);
    

	
    // success: wxApp::OnRun() will be called which will enter the main message
    // loop and the application will run. If we returned FALSE here, the
    // application would exit immediately.
    return TRUE;
}

// frame constructor
MyFrame::MyFrame(const wxString& title, const wxPoint& pos, const wxSize& size)
       : wxFrame((wxFrame *)NULL, -1, title, pos, size)
{

	vtkMetaImageReader *Reader=vtkMetaImageReader::New();
//	Reader->SetFileName(argv[1]);
	Reader->SetFileName("/home/valette/sphere.mhd");
	Reader->Update();
	

	ManualPaintModel *mpModel = new ManualPaintModel;
	mpModel->SetImage(Reader->GetOutput());

	wxManualPaintPanel *mpPanel = new wxManualPaintPanel(this);
	mpPanel->SetManualPaintModel(mpModel);
/*
	MyRenderWindow=wxRenderWindow::New(this, MY_VTK_WINDOW);

  vtkConeSource     *pConeSource;
  pConeSource   = vtkConeSource::New();
  pConeSource->SetResolution(800);

	MyRenderWindow->SetInput(pConeSource->GetOutput());
	pConeSource->Delete();
		RenderWindowWidgets *RWidgets= new RenderWindowWidgets(this, 1000,wxPanelNameStr,
	wxDefaultPosition,wxDefaultSize,wxWANTS_CHARS | wxNO_FULL_REPAINT_ON_RESIZE);
	RWidgets->Show(TRUE);*/

}

MyFrame::~MyFrame()
{
}

// event handlers

void MyFrame::OnQuit(wxCommandEvent& WXUNUSED(event))
{
    // TRUE is to force the frame to close
    Close(TRUE);
}
/*
int main( int argc, char *argv[] )
{

	vtkMetaImageReader *Reader=vtkMetaImageReader::New();
	Reader->SetFileName(argv[1]);
	Reader->Update();
	

	ManualPaintModel *mpModel = new ManualPaintModel;
	mpModel->SetImage(Reader->GetOutput());

	wxManualPaintPanel *mpPanel = new wxManualPaintPanel;
	mpPanel->SetManualPaintModel(mpModel);


	return (0);
}
*/
